<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" />

  <xsl:param name="showa" select="'昭和'" />
  <xsl:param name="heisei" select="'平成'" />
  <xsl:param name="post-heisei" select="'&#x32FF;'" />
  <!-- you can change following to '01' to avoid gan-nen notation -->
  <xsl:param name="gan-nen" select="'元'" />
  <xsl:param name="year-fmt" select="'00'" />
  <xsl:param name="test-nengappijihun" select="'2018-06-20T12:34:56+09:00'" />

  <xsl:template name="normalize-ymdh">
    <xsl:param name="y" select="2018"/>
    <xsl:param name="m" select="12"/>
    <xsl:param name="d" select="31"/>
    <xsl:param name="h" select="29"/>
    <xsl:choose>
    <xsl:when test="$h &gt;= 24">
      <xsl:variable name="dend">
        <xsl:choose>
        <xsl:when test="$m = 2 and $y mod 4 = 0">29</xsl:when>
        <xsl:when test="$m = 2">28</xsl:when>
        <xsl:when test="$m = 4 or $m = 6 or $m = 9 or $m = 11">30</xsl:when>
        <xsl:otherwise>31</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="$d = number($dend)">
        <xsl:variable name="yyyy-mm">
          <xsl:choose>
          <xsl:when test="$m = 12">
            <xsl:value-of select="concat(format-number($y + 1, '0000'), '-01')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of
            select="concat(format-number($y, '0000'), '-',
            format-number($m + 1, '00'))" />
          </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:value-of
        select="concat($yyyy-mm, '-01T', format-number($h - 24, '00'))" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat(
          format-number($y, '0000'), '-',
          format-number($m, '00'), '-',
          format-number($d + 1, '00'), 'T',
          format-number($h - 24, '00')
        )" />
      </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="$h &lt; 0">
      <xsl:variable name="dend">
        <xsl:choose>
        <xsl:when test="$m = 3 and $y mod 4 = 0">29</xsl:when>
        <xsl:when test="$m = 3">28</xsl:when>
        <xsl:when test="$m = 5 or $m = 7 or $m = 10 or $m = 12">30</xsl:when>
        <xsl:otherwise>31</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="$d = 1">
        <xsl:variable name="yyyy-mm">
          <xsl:choose>
          <xsl:when test="$m = 1">
            <xsl:value-of select="concat(format-number($y - 1, '0000'), '-12')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of
            select="concat(format-number($y, '0000'), '-',
            format-number($m - 1, '00'))" />
          </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:value-of
        select="concat($yyyy-mm, '-', $dend, 'T', format-number($h + 24, '00'))" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat(
          format-number($y, '0000'), '-',
          format-number($m, '00'), '-',
          format-number($d - 1, '00'), 'T',
          format-number($h + 24, '00')
        )" />
      </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="concat(
        format-number($y, '0000'), '-',
        format-number($m, '00'), '-',
        format-number($d, '00'), 'T',
        format-number($h, '00')
      )" />
    </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="display-gengou-year">
    <xsl:param name="y" select="2018"/>
    <xsl:param name="m" select="12"/>
    <xsl:param name="d" select="31"/>
    <xsl:choose>
    <xsl:when test="$y &lt; 1927">
      <xsl:value-of select="format-number($y, '0000')" />
    </xsl:when>
    <xsl:when test="$y &lt; 1989 or ($y = 1989 and $m = 1 and $d &lt; 8)">
      <xsl:value-of select="concat($showa, format-number($y - 1925, $year-fmt))" />
    </xsl:when>
    <xsl:when test="$y = 1989">
      <xsl:value-of select="concat($heisei, $gan-nen)" />
    </xsl:when>
    <xsl:when test="$y &lt; 2019 or ($y = 2019 and $m &lt; 5)">
      <xsl:value-of select="concat($heisei, format-number($y - 1988, $year-fmt))" />
    </xsl:when>
    <xsl:when test="$y = 2019">
      <xsl:value-of select="concat($post-heisei, $gan-nen)" />
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="concat($post-heisei, format-number($y - 2018, $year-fmt))" />
    </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="nengappijihun">
    <xsl:param name="t" />
    <xsl:variable name="tfmt" select="translate($t, '012345678','999999999')" />
    <xsl:variable name="tz" select="substring-after($t, '+')" />
    <xsl:choose>
    <xsl:when test="$tfmt = '9999-99-99T99:99:99+99:99' and $tz = '09:00'">
      <xsl:variable name="year">
        <xsl:call-template name="display-gengou-year">
          <xsl:with-param name="y" select="number(substring($t, 1, 4))" />
          <xsl:with-param name="m" select="number(substring($t, 6, 2))" />
          <xsl:with-param name="d" select="number(substring($t, 9, 2))" />
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="concat(
      $year, '年',
      substring($t, 6, 2), '月',
      substring($t, 9, 2), '日',
      substring($t, 12, 2), '時',
      substring($t, 15, 2), '分')" />
    </xsl:when>
    <xsl:when test="$tfmt = '9999-99-99T99:99:99Z' or
    ($tfmt = '9999-99-99T99:99:99+99:99' and $tz = '00:00')">
      <xsl:variable name="ymdh">
        <xsl:call-template name="normalize-ymdh">
          <xsl:with-param name="y" select="number(substring($t, 1, 4))" />
          <xsl:with-param name="m" select="number(substring($t, 6, 2))" />
          <xsl:with-param name="d" select="number(substring($t, 9, 2))" />
          <xsl:with-param name="h" select="number(substring($t, 12, 2)) - 9" />
        </xsl:call-template>
      </xsl:variable>
      <xsl:call-template name="nengappijihun">
        <xsl:with-param name="t"
        select="concat($ymdh, substring($t, 14, 6), '+09:00')" />
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <!-- unexpected - just for failsafe -->
      <xsl:value-of select="$t" />
    </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- for test -->
  <xsl:template match="/">
    <xsl:call-template name="nengappijihun">
      <xsl:with-param name="t" select="$test-nengappijihun" />
    </xsl:call-template>
  </xsl:template>

</xsl:stylesheet>
