def gamma r
  if r < 0.00174 then 32 * r
  else r ** (1.0 / 2.2)
  end
end

def xy2rgb x, y
  z = 1.0 - x - y
  yinv = 0.33 / y
  x *= yinv
  y *= yinv
  z *= yinv
  r = 2.041588 * x - 0.565007 * y - 0.344731 * z
  g = -0.969244 * x + 1.875968 * y + 0.041555 * z
  b = 0.013444 * x - 0.118362 * y + 1.015175 * z
  [(gamma(r) * 255).floor, (gamma(g) * 255).floor, (gamma(b) * 255).floor]
end

def star x, y
  18.times {|iy|
    line = []
    slant = (iy - 6) * 0.088
    25.times {|ix|
      dx = 0.04 * ix
      mx = x - dx
      my = y + dx * slant
      rgb = xy2rgb(mx, my)
      next if rgb.min < 0 or rgb.max > 255
      line.push rgb
    }
    if line.size > 1
      for rgb in line
        puts rgb.join("\t")
      end
      puts "-1\t-1\t-1"
    end
  }
end

def star3 x, y
  18.times {|ix|
    line = []
    slant = (ix - 6) * 0.1
    25.times {|iy|
      dy = 0.045 * iy
      mx = x + dy * slant
      my = y + dy
      rgb = xy2rgb(mx, my)
      next if rgb.min < 0 or rgb.max > 255
      line.push rgb
    }
    if line.size > 1
      for rgb in line
        puts rgb.join("\t")
      end
      puts "-1\t-1\t-1"
    end
  }
end

puts "#$0 [1|2]" if ARGV.empty?
for arg in ARGV
  case arg
  when '1' then
    puts "#: az=220 ax=22.5 ay=85"
    puts "#: az=223 ax=25 ay=80 nx=300 ny=320"
    star 0.7347, 0.2653
  when '2' then
    puts "#: az=220 ax=22.5 ay=85"
    puts "#: az=217 ax=20 ay=91 nx=300 ny=320"
    star 1.1, -0.07
  else
    puts "#: ax=-8 ay=-2 az=-139.6"
    star3 0.1733, 0.0048
  end
end
