<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="*[local-name()='CT_CodelistCatalogue']">
  <xsl:variable name="title">
    CodeList Catalog
    <xsl:if test="*[local-name()='name']">
    <xsl:value-of select="concat('&#x201F;', 
      normalize-space(*[local-name()='name']), '&#x201D;')"/>
    </xsl:if>
    <xsl:if test="*[local-name()='versionNumber']">
    <xsl:value-of
      select="concat(' version ', *[local-name()='versionNumber'])"/>
    </xsl:if>
  </xsl:variable>
  <html>
  <head>
  <title><xsl:value-of select="normalize-space($title)"/></title>
  <style type="text/css"><![CDATA[
  body {
   margin: 0 20px 20px 20px;
   padding-bottom: 20px;
   border-bottom: 2px solid grey;
  }
  h1 {
    padding-top: 4px;
    padding-bottom: 4px;
    border-top: 6px solid grey;
    border-bottom: 6px solid grey;
  }
  h2 {
    padding-left: 4px;
    border-left: 6px solid grey;
    border-bottom: 3px solid grey;
  }
  table {
    border-collapse: collapse;
  }
  td, th {
    padding-left: 4px;
    padding-right: 4px;
    border: 1px solid grey;
    white-space: normal;
  }
  td.br {
    word-break: break-all;
  }
  ]]></style>
  </head>
  <body>
  <h1>
    <xsl:choose>
    <xsl:when test="/processing-instruction('document-uri')">
      <a href="{/processing-instruction('document-uri')}">
      <xsl:value-of select="normalize-space($title)"/>
      </a>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="normalize-space($title)"/>
    </xsl:otherwise>
    </xsl:choose>
  </h1>

  <ul>
  <xsl:for-each select="*[local-name()='codelistItem']">
    <li>
    <a href="#{normalize-space(*/*[local-name()='identifier'])}">
    Codelist
    <xsl:value-of select="*/*[local-name()='identifier']"/>
    </a>
    </li>
  </xsl:for-each>
  </ul>

  <h2>About this Catalogue</h2>
  <table>
  <xsl:for-each select="/processing-instruction('document-uri')">
    <tr>
    <th>document-uri</th>
    <td><a href="{.}"><xsl:value-of select="."/></a></td>
    </tr>
  </xsl:for-each>
  <xsl:for-each select="*[local-name()!='codelistItem']">
    <tr>
    <th><xsl:value-of select="local-name()"/></th>
    <td><xsl:value-of select="."/></td>
    </tr>
  </xsl:for-each>
  </table>

  <xsl:for-each select="*[local-name()='codelistItem']">
    <xsl:variable name="have_remarks"
    select="count(.//*[local-name()='remarks']) &gt; 0"/>
    <h2>
    <a name="{normalize-space(*/*[local-name()='identifier'])}">
    Codelist
    <xsl:value-of select="*/*[local-name()='identifier']"/>
    (codeSpace <xsl:value-of select="*/*[local-name()='identifier']/@codeSpace"/>)
    </a>
    </h2>
    <p><xsl:value-of select="*/*[local-name()='description']"/></p>
    <table>
    <tr>
      <th>code</th>
      <th>codeSpace</th>
      <th>description</th>
      <xsl:if test="$have_remarks">
        <th>remarks</th>
      </xsl:if>
    </tr>
    <xsl:for-each select="*/*[local-name()='codeEntry']">
      <tr>
      <xsl:variable name="idr" select="*/*[local-name()='identifier']"/>
      <td>
	<xsl:if test="(string-length($idr) &gt; 32)
	and not(contains($idr, ' '))">
	  <xsl:attribute name="class">br</xsl:attribute>
	</xsl:if>
	<a name="{*/@*[local-name()='id']}">
	<b><xsl:value-of select="$idr"/></b>
	</a>
      </td>
      <td>
        <xsl:value-of select="*/*[local-name()='identifier']/@codeSpace"/>
      </td>
      <td>
	<xsl:value-of select="*/*[local-name()='description']"/>
      </td>
      <xsl:if test="$have_remarks">
        <td><xsl:value-of select="*/*[local-name()='remarks']"/></td>
      </xsl:if>
      </tr>
    </xsl:for-each>
    </table>
  </xsl:for-each>
  </body>
  </html>
</xsl:template>

<xsl:template match="*">
  <xsl:choose>
  <xsl:when test="count(@codeList)>0 and count(@codeListValue)>0">
    <tr>
    <td>
    <a href="{@codeList}"><xsl:value-of select="@codeListValue"/></a>
    </td>
    <td>
    <xsl:value-of select="string()"/>
    </td>
    </tr>
  </xsl:when>
  <xsl:when test="starts-with(local-name(), 'MD_')
or starts-with(local-name(), 'CI_')
or starts-with(local-name(), 'DQ_')
or starts-with(local-name(), 'LI_')
or starts-with(local-name(), 'EX_')
or namespace-uri()='http://www.isotc211.org/2005/gco'">
    <xsl:for-each select="@*">
      <tr>
      <th>@<xsl:value-of select="local-name()" /></th>
      <td><xsl:value-of select="string()" /></td>
      </tr>
    </xsl:for-each>
    <xsl:apply-templates />
  </xsl:when>
  <xsl:when test="local-name()='electronicMailAddress'">
    <tr>
    <th>email:</th>
    <td>
    <a href="mailto:{normalize-space(string())}"><xsl:value-of select="."/></a>
    </td>
    </tr>
  </xsl:when>
  <xsl:when test="local-name()='URL'
or local-name()='code' and starts-with(normalize-space(string()), 'http://')">
    <tr>
    <th>URL:</th>
    <td>
    <a href="{normalize-space(string())}"><xsl:value-of select="."/></a>
    </td>
    </tr>
  </xsl:when>
  <xsl:otherwise>
    <tr>
    <th><xsl:value-of select="local-name()" />
    </th>
    <td>
    <xsl:choose>
    <xsl:when test="count(*) > 0
and not(namespace-uri(*[1])='http://www.isotc211.org/2005/gco')">
      <table>
      <xsl:apply-templates />
      </table>
    </xsl:when>
    <xsl:otherwise>
      <table>
      <xsl:for-each select="@*">
	<tr>
	<th>@<xsl:value-of select="local-name()" /></th>
	<td><xsl:value-of select="string()" /></td>
	</tr>
      </xsl:for-each>
      </table>
      <xsl:apply-templates />
    </xsl:otherwise>
    </xsl:choose>
    </td>
    </tr>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="text()">
  <xsl:choose>
  <xsl:when test="starts-with(text(), 'http://')">
    &lt;a href=&quot;<xsl:value-of select="." />&quot;
    <xsl:value-of select="." />&lt;/a&gt;
  </xsl:when>
  <xsl:otherwise>
  <xsl:value-of select="." />
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
