Attribute VB_Name = "VBAXSLraw2gmd"
Function sXSLraw2gmd() As String
Dim r As String
r = ""
r = r + "<?xml version=""1.0"" encoding=""UTF-8""?>" + Chr$(13) + Chr$(10)
r = r + "<xsl:stylesheet version=""1.0""" + Chr$(13) + Chr$(10)
r = r + " xmlns:xsl=""http://www.w3.org/1999/XSL/Transform""" + Chr$(13) + Chr$(10)
r = r + " xmlns:gmd=""http://www.isotc211.org/2005/gmd""" + Chr$(13) + Chr$(10)
r = r + " xmlns:gco=""http://www.isotc211.org/2005/gco""" + Chr$(13) + Chr$(10)
r = r + " xmlns:gml=""http://www.opengis.net/gml/3.2""" + Chr$(13) + Chr$(10)
r = r + " xmlns:gmx=""http://www.isotc211.org/2005/gmx""" + Chr$(13) + Chr$(10)
r = r + " xmlns:gts=""http://www.isotc211.org/2005/gts""" + Chr$(13) + Chr$(10)
r = r + " xmlns:gmi=""http://www.isotc211.org/2005/gmi""" + Chr$(13) + Chr$(10)
r = r + " xmlns:xlink=""http://www.w3.org/1999/xlink""" + Chr$(13) + Chr$(10)
r = r + " xmlns:xsi=""http://www.w3.org/2001/XMLSchema-instance""" + Chr$(13) + Chr$(10)
r = r + " exclude-result-prefixes=""xlink""" + Chr$(13) + Chr$(10)
r = r + " >" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:output method=""xml"" encoding=""UTF-8"" indent=""yes""/>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<!-- global parameters -->" + Chr$(13) + Chr$(10)
r = r + "<xsl:param name=""CDTB"" select=""'http://wis.wmo.int/2008/catalogues/draft_version_1-1/WMO_Codelists_ver1_1.xml'""/>" + Chr$(13) + Chr$(10)
r = r + "<xsl:param name=""ISTB"" select=""'http://www.isotc211.org/2005/resources/Codelist/gmxCodelists.xml'""/>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template match=""/"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:apply-templates />" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template match=""bmd"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""ttaaii"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""normalize-space(dataset/p[k='TTAAii']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""cccc"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""normalize-space(dataset/p[k='CCCC']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""prodid"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat($ttaaii, $cccc)""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:if test=""$ttaaii = ''"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:message terminate=""yes"">TTAAii missing</xsl:message>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:if test=""$cccc = ''"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:message terminate=""yes"">CCCC missing</xsl:message>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""title"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat('WIS/GTS bulletin ', $ttaaii, ' '," + Chr$(13) + Chr$(10)
r = r + "    $cccc, ' in ', dataset/p[k='CodeForm']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='Param']"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""concat(' of ', dataset/p[k='Param']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='Level']"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""concat(' at ', dataset/p[k='Level']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='FT']"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""concat(' for ft=', dataset/p[k='FT']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='Remarks']"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""concat(' (', dataset/p[k='Remarks']/v, ')')""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""dataURL"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat(" + Chr$(13) + Chr$(10)
r = r + "      'http://www.wis-jma.go.jp/gisccache/'," + Chr$(13) + Chr$(10)
r = r + "      'urn:x-wmo:md:int.wmo.wis::', $prodid" + Chr$(13) + Chr$(10)
r = r + "    )""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "  <gmd:MD_Metadata>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:attribute name=""xsi:schemaLocation""><!--" + Chr$(13) + Chr$(10)
r = r + " -->http://www.isotc211.org/2005/gmd<!--" + Chr$(13) + Chr$(10)
r = r + "--> http://wis.wmo.int/2011/schemata/iso19139_2007/schema/gmd/gmd.xsd<!--" + Chr$(13) + Chr$(10)
r = r + "--></xsl:attribute>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "  <!-- === fileIdentifier === -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:fileIdentifier>" + Chr$(13) + Chr$(10)
r = r + "    <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat('urn:x-wmo:md:int.wmo.wis::', $prodid)""/>" + Chr$(13) + Chr$(10)
r = r + "    </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:fileIdentifier>" + Chr$(13) + Chr$(10)
r = r + "  <!-- Language: fixed English -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:language>" + Chr$(13) + Chr$(10)
r = r + "    <gco:CharacterString>eng</gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:language>" + Chr$(13) + Chr$(10)
r = r + "  <!-- Character Set: fixed UTF-8 -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:characterSet>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:MD_CharacterSetCode codeList=""{$CDTB}#MD_CharacterSetCode""" + Chr$(13) + Chr$(10)
r = r + "    codeListValue=""utf8"" />" + Chr$(13) + Chr$(10)
r = r + "  </gmd:characterSet>" + Chr$(13) + Chr$(10)
r = r + "  <!-- Parent Identifier -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- Hierarchy Level: fixed -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:hierarchyLevel>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:MD_ScopeCode codeList=""{$CDTB}#MD_ScopeCode""" + Chr$(13) + Chr$(10)
r = r + "    codeListValue=""dataset"" />" + Chr$(13) + Chr$(10)
r = r + "  </gmd:hierarchyLevel>" + Chr$(13) + Chr$(10)
r = r + "  <!-- Hierarchy Level Name: fixed -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:hierarchyLevelName>" + Chr$(13) + Chr$(10)
r = r + "    <gco:CharacterString>Dataset in WIS/GTS</gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:hierarchyLevelName>" + Chr$(13) + Chr$(10)
r = r + "  <!-- Contact -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:contact>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:apply-templates select=""contact[@role='MetadataContact']""/>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:contact>" + Chr$(13) + Chr$(10)
r = r + "  <!-- Date Stamp -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:dateStamp>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:call-template name=""makeDateProp"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:with-param name=""input"" select=""dateStamp""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:dateStamp>" + Chr$(13) + Chr$(10)
r = r + "  <!-- Metadata Standard Name -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:metadataStandardName>" + Chr$(13) + Chr$(10)
r = r + "    <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat(" + Chr$(13) + Chr$(10)
r = r + "    'WMO Core Metadata Profile of ISO 19115 (WMO Core), '," + Chr$(13) + Chr$(10)
r = r + "    '2003/Cor.1:2006 (ISO 19115), 2007 (ISO/TS 19139)')""/>" + Chr$(13) + Chr$(10)
r = r + "    </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:metadataStandardName>" + Chr$(13) + Chr$(10)
r = r + "  <!-- Metadata Standard Version -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:metadataStandardVersion>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:comment>Converter $Id: VBAXSLraw2gmd.bas,v 1.3 2012/10/25 01:16:59 toyoda Exp $</xsl:comment>" + Chr$(13) + Chr$(10)
r = r + "    <gco:CharacterString>1.3</gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:metadataStandardVersion>" + Chr$(13) + Chr$(10)
r = r + "  <!-- dataSetURI -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:dataSetURI>" + Chr$(13) + Chr$(10)
r = r + "    <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""$dataURL""/>" + Chr$(13) + Chr$(10)
r = r + "    </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:dataSetURI>" + Chr$(13) + Chr$(10)
r = r + "  <!-- locale -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- spatialRepresentationInfo -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- referenceSystemInfo -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- metadataExtensionInfo -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- === Identification Information === -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:identificationInfo>" + Chr$(13) + Chr$(10)
r = r + "  <gmd:MD_DataIdentification>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""TimeGroupP"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""TimeGroup-parse"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:with-param name=""TimeGroup""" + Chr$(13) + Chr$(10)
r = r + "   select=""normalize-space(dataset/p[k='TimeGroup']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/citation -->" + Chr$(13) + Chr$(10)
r = r + "    <gmd:citation>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:CI_Citation>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:title>" + Chr$(13) + Chr$(10)
r = r + "      <gco:CharacterString><xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "      select=""normalize-space($title)""/></gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:title>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:date>" + Chr$(13) + Chr$(10)
r = r + "        <gmd:CI_Date>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:date>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:call-template name=""makeDateProp"">" + Chr$(13) + Chr$(10)
r = r + "     <xsl:with-param name=""input"" select=""dataset/p[k='Date']/v""/>" + Chr$(13) + Chr$(10)
r = r + "     </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:date>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:dateType><gmd:CI_DateTypeCode codeList=""{$CDTB}#CI_DateTypeCode""" + Chr$(13) + Chr$(10)
r = r + "     codeListValue=""revision"" /></gmd:dateType>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:CI_Date>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:date>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:identifier>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:MD_Identifier>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:code>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of select=""$dataURL""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:code>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:MD_Identifier>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:identifier>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:CI_Citation>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:citation>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/abstract -->" + Chr$(13) + Chr$(10)
r = r + "    <gmd:abstract>" + Chr$(13) + Chr$(10)
r = r + "    <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""concat('WIS/GTS bulletin ', $prodid)""/>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""dataset/p[k='CodeForm']"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""concat('; in code form: '," + Chr$(13) + Chr$(10)
r = r + "   dataset/p[k='CodeForm']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""dataset/p[k='Param']"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "   select=""concat('; of parameter: ', dataset/p[k='Param']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""dataset/p[k='Level']"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "   select=""concat('; at level ', dataset/p[k='Level']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""dataset/p[k='FT']"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "   select=""concat('; for forecast time ', dataset/p[k='FT']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""dataset/p[k='RTH']"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""concat('; disseminated via: RTH '," + Chr$(13) + Chr$(10)
r = r + "   dataset/p[k='RTH']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""dataset/p[k='Remarks']"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""concat('; remarks: '," + Chr$(13) + Chr$(10)
r = r + "   dataset/p[k='Remarks']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""dataset/p[k='Stations']/item"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""'; stations: '""/>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:for-each select=""dataset/p[k='Stations']/item"">" + Chr$(13) + Chr$(10)
r = r + "     <xsl:if test=""position() &gt; 1"">, </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:call-template name=""station-item-abstract""/>" + Chr$(13) + Chr$(10)
r = r + "   </xsl:for-each>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""'.'""/>" + Chr$(13) + Chr$(10)
r = r + "    </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:abstract>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/purpose -->" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/credit -->" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/status -->" + Chr$(13) + Chr$(10)
r = r + "    <gmd:status>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:MD_ProgressCode codeList=""{$CDTB}#MD_ProgressCode""" + Chr$(13) + Chr$(10)
r = r + "     codeListValue=""onGoing"">onGoing</gmd:MD_ProgressCode>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:status>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/pointOfContact -->" + Chr$(13) + Chr$(10)
r = r + "    <gmd:pointOfContact>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:apply-templates select=""contact[@role='DataContact']""/>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:pointOfContact>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/resourceMaintenance -->" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='TimeGroup']"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""resourceMaintenance"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:with-param name=""TimeGroupP"" select=""$TimeGroupP""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/graphicOverview -->" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/resourceFormat -->" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/descriptiveKeywords -->" + Chr$(13) + Chr$(10)
r = r + "    <gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_Keywords id=""subjkey"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>GTS</gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:type>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:MD_KeywordTypeCode" + Chr$(13) + Chr$(10)
r = r + "   codeList=""{$CDTB}#MD_KeywordTypeCode""" + Chr$(13) + Chr$(10)
r = r + "   codeListValue=""discipline"" />" + Chr$(13) + Chr$(10)
r = r + "   </gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:MD_Keywords>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='Stations']/item[table='VOLA']"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_Keywords id=""placecode-VOLA"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:for-each select=""dataset/p[k='Stations']/item[table='VOLA']"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:call-template name=""station-item-keyword""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:for-each>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_KeywordTypeCode" + Chr$(13) + Chr$(10)
r = r + "   codeList=""{$CDTB}#MD_KeywordTypeCode""" + Chr$(13) + Chr$(10)
r = r + "   codeListValue=""place"" />" + Chr$(13) + Chr$(10)
r = r + "      </gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:thesaurusName>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:CI_Citation>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:title>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of select=""'WMO Pub No 9 Vol A'""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:title>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:date gco:nilReason=""missing"" />" + Chr$(13) + Chr$(10)
r = r + "   </gmd:CI_Citation>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:thesaurusName>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:MD_Keywords>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='Stations']/item[table='CCCC']"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_Keywords id=""placecode-CCCC"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:for-each select=""dataset/p[k='Stations']/item[table='CCCC']"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:call-template name=""station-item-keyword""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:for-each>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_KeywordTypeCode" + Chr$(13) + Chr$(10)
r = r + "   codeList=""{$CDTB}#MD_KeywordTypeCode""" + Chr$(13) + Chr$(10)
r = r + "   codeListValue=""place"" />" + Chr$(13) + Chr$(10)
r = r + "      </gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:thesaurusName>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:CI_Citation>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:title>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of select=""'ICAO Doc 7910: Location Indicator'""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:title>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:date gco:nilReason=""missing"" />" + Chr$(13) + Chr$(10)
r = r + "   </gmd:CI_Citation>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:thesaurusName>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:MD_Keywords>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='Level']"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_Keywords id=""stratkey"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:for-each select=""dataset/p[k='Level']"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString><xsl:value-of select=""v""/></gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:for-each>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_KeywordTypeCode" + Chr$(13) + Chr$(10)
r = r + "      codeList=""{$CDTB}#MD_KeywordTypeCode""" + Chr$(13) + Chr$(10)
r = r + "      codeListValue=""stratum"" />" + Chr$(13) + Chr$(10)
r = r + "      </gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:MD_Keywords>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='FT']"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_Keywords id=""updtime-ft"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:for-each select=""dataset/p[k='FT']"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString><xsl:value-of select=""concat('Forecast PT', number(v), 'H')""/></gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:for-each>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_KeywordTypeCode" + Chr$(13) + Chr$(10)
r = r + "      codeList=""{$CDTB}#MD_KeywordTypeCode""" + Chr$(13) + Chr$(10)
r = r + "      codeListValue=""temporal"" />" + Chr$(13) + Chr$(10)
r = r + "      </gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:MD_Keywords>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""contains($TimeGroupP, '|times=')"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_Keywords id=""updtime-rt"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""TimeGroup-keyword"">" + Chr$(13) + Chr$(10)
r = r + "        <xsl:with-param name=""times""" + Chr$(13) + Chr$(10)
r = r + "   select=""substring-before(substring-after(" + Chr$(13) + Chr$(10)
r = r + "   $TimeGroupP, 'times='), '|')""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""dataest/p[k='AsNeeded']"">" + Chr$(13) + Chr$(10)
r = r + "        <gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""dataest/p[k='AsNeeded']/v""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "        </gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_KeywordTypeCode" + Chr$(13) + Chr$(10)
r = r + "      codeList=""{$CDTB}#MD_KeywordTypeCode""" + Chr$(13) + Chr$(10)
r = r + "      codeListValue=""temporal"" />" + Chr$(13) + Chr$(10)
r = r + "      </gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:MD_Keywords>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='Param']"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_Keywords id=""themekey-parameter"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:for-each select=""dataset/p[k='Param']"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString><xsl:value-of select=""v""/></gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:for-each>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_KeywordTypeCode" + Chr$(13) + Chr$(10)
r = r + "      codeList=""{$CDTB}#MD_KeywordTypeCode""" + Chr$(13) + Chr$(10)
r = r + "      codeListValue=""theme"" />" + Chr$(13) + Chr$(10)
r = r + "      </gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:MD_Keywords>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='CodeForm']"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_Keywords id=""themekey-codeform"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:for-each select=""dataset/p[k='CodeForm']"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString><xsl:value-of select=""v""/></gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:for-each>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_KeywordTypeCode" + Chr$(13) + Chr$(10)
r = r + "      codeList=""{$CDTB}#MD_KeywordTypeCode""" + Chr$(13) + Chr$(10)
r = r + "      codeListValue=""theme"" />" + Chr$(13) + Chr$(10)
r = r + "      </gmd:type>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:MD_Keywords>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:descriptiveKeywords>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/resourceSpecificUsage -->" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/resourceConstraints -->" + Chr$(13) + Chr$(10)
r = r + "    <gmd:resourceConstraints>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""rc"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""Constraints-Build"">" + Chr$(13) + Chr$(10)
r = r + "        <xsl:with-param name=""TTAAii"" select=""$ttaaii""/>" + Chr$(13) + Chr$(10)
r = r + "        <xsl:with-param name=""CodeForm"" select=""dataset/p[k='CodeForm']/v""/>" + Chr$(13) + Chr$(10)
r = r + "        <xsl:with-param name=""Category"" select=""dataset/p[k='Category']/v""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:MD_LegalConstraints>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""contains($rc, 'ul=')"">" + Chr$(13) + Chr$(10)
r = r + "        <gmd:useLimitation>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "       <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "       select=""substring-before(substring-after($rc, 'ul='), '|')""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "        </gmd:useLimitation>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:accessConstraints>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:MD_RestrictionCode" + Chr$(13) + Chr$(10)
r = r + "   codeList=""{$CDTB}#MD_RestrictionCode""" + Chr$(13) + Chr$(10)
r = r + "   codeListValue=""otherRestrictions""" + Chr$(13) + Chr$(10)
r = r + "   >otherRestrictions</gmd:MD_RestrictionCode>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:accessConstraints>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:useConstraints>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:MD_RestrictionCode" + Chr$(13) + Chr$(10)
r = r + "   codeList=""{$CDTB}#MD_RestrictionCode""" + Chr$(13) + Chr$(10)
r = r + "   codeListValue=""otherRestrictions""" + Chr$(13) + Chr$(10)
r = r + "   >otherRestrictions</gmd:MD_RestrictionCode>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:useConstraints>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:otherConstraints>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "   select=""substring-before(substring-after($rc, 'dl='), '|')""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:otherConstraints>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""contains($rc, 'pr=')"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:otherConstraints>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "   select=""substring-before(substring-after($rc, 'pr='), '|')""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:otherConstraints>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:MD_LegalConstraints>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:resourceConstraints>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/aggregationInfo -->" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/spatialRepresentationType -->" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/spatialResolution -->" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='Resolution']"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:spatialResolution>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:MD_Resolution>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:distance>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:element name=""gco:Distance"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:attribute name=""uom"">km</xsl:attribute>" + Chr$(13) + Chr$(10)
r = r + "        <xsl:value-of select=""dataset/p[k='Resolution']/v""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:element>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:distance>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:MD_Resolution>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:spatialResolution>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/language -->" + Chr$(13) + Chr$(10)
r = r + "    <gmd:language>" + Chr$(13) + Chr$(10)
r = r + "      <gco:CharacterString>eng</gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:language>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/characterSet -->" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/topicCategory -->" + Chr$(13) + Chr$(10)
r = r + "    <gmd:topicCategory>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:MD_TopicCategoryCode>climatologyMeteorologyAtmosphere</gmd:MD_TopicCategoryCode>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:topicCategory>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/environmentDescription -->" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/extent -->" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "    <gmd:extent>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:EX_Extent id=""boundingExtent"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:geographicElement>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:EX_GeographicBoundingBox id=""boundingGeographicBoundingBox"">" + Chr$(13) + Chr$(10)
r = r + "        <xsl:variable name=""bbox"">" + Chr$(13) + Chr$(10)
r = r + "     <xsl:call-template name=""make-bbox""/>" + Chr$(13) + Chr$(10)
r = r + "   </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "        <gmd:westBoundLongitude>" + Chr$(13) + Chr$(10)
r = r + "     <gco:Decimal>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "     select=""substring-before(substring-after($bbox, 'W='), '|')""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:Decimal>" + Chr$(13) + Chr$(10)
r = r + "        </gmd:westBoundLongitude>" + Chr$(13) + Chr$(10)
r = r + "        <gmd:eastBoundLongitude>" + Chr$(13) + Chr$(10)
r = r + "     <gco:Decimal>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "     select=""substring-before(substring-after($bbox, 'E='), '|')""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:Decimal>" + Chr$(13) + Chr$(10)
r = r + "        </gmd:eastBoundLongitude>" + Chr$(13) + Chr$(10)
r = r + "        <gmd:southBoundLatitude>" + Chr$(13) + Chr$(10)
r = r + "     <gco:Decimal>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "     select=""substring-before(substring-after($bbox, 'S='), '|')""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:Decimal>" + Chr$(13) + Chr$(10)
r = r + "        </gmd:southBoundLatitude>" + Chr$(13) + Chr$(10)
r = r + "        <gmd:northBoundLatitude>" + Chr$(13) + Chr$(10)
r = r + "     <gco:Decimal>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "     select=""substring-before(substring-after($bbox, 'N='), '|')""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:Decimal>" + Chr$(13) + Chr$(10)
r = r + "        </gmd:northBoundLatitude>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:EX_GeographicBoundingBox>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:geographicElement>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:EX_Extent>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:extent>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""dataset/p[k='FT']"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:extent>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:EX_Extent id=""relativeExtent"">" + Chr$(13) + Chr$(10)
r = r + "      <gmd:description>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""concat(" + Chr$(13) + Chr$(10)
r = r + "   'Forecast time: ', dataset/p[k='FT']/v, ' [h]')""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:description>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:temporalElement>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:EX_TemporalExtent id=""relativeTemporalExtent"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:extent>" + Chr$(13) + Chr$(10)
r = r + "   <gml:TimePeriod gml:id=""fcstTimeRange"">" + Chr$(13) + Chr$(10)
r = r + "   <gml:begin nilReason=""unknown"" />" + Chr$(13) + Chr$(10)
r = r + "   <gml:end nilReason=""unknown"" />" + Chr$(13) + Chr$(10)
r = r + "   <gml:timeInterval unit=""hour"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""dataset/p[k='FT']/v""/>" + Chr$(13) + Chr$(10)
r = r + "   </gml:timeInterval>" + Chr$(13) + Chr$(10)
r = r + "   </gml:TimePeriod>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:extent>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:EX_TemporalExtent>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:temporalElement>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:EX_Extent>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:extent>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "    <!-- identificationInfo/*/supplementalInformation -->" + Chr$(13) + Chr$(10)
r = r + "    </gmd:MD_DataIdentification>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:identificationInfo>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "  <!-- contentInfo -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- distributionInformation -->" + Chr$(13) + Chr$(10)
r = r + "  <gmd:distributionInfo>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:MD_Distribution>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:for-each select=""dataset/p[k='CodeForm']"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:distributionFormat>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:MD_Format>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:name>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:when test=""contains(v, '/')"">" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of select=""substring-before(v, '/')""/>" + Chr$(13) + Chr$(10)
r = r + "     </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of select=""v""/>" + Chr$(13) + Chr$(10)
r = r + "     </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "     </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "     </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:name>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:version>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of select=""substring-after(v, '/')""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:version>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:MD_Format>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:distributionFormat>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:for-each>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:distributor>" + Chr$(13) + Chr$(10)
r = r + "        <gmd:MD_Distributor>" + Chr$(13) + Chr$(10)
r = r + "        <gmd:distributorContact>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:apply-templates select=""contact[@role='RTH']""/>" + Chr$(13) + Chr$(10)
r = r + "        </gmd:distributorContact>" + Chr$(13) + Chr$(10)
r = r + "        </gmd:MD_Distributor>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:distributor>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:transferOptions>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:MD_DigitalTransferOptions>" + Chr$(13) + Chr$(10)
r = r + "     <gmd:onLine>" + Chr$(13) + Chr$(10)
r = r + "     <gmd:CI_OnlineResource>" + Chr$(13) + Chr$(10)
r = r + "     <gmd:linkage>" + Chr$(13) + Chr$(10)
r = r + "       <gmd:URL><xsl:value-of select=""$dataURL""/></gmd:URL>" + Chr$(13) + Chr$(10)
r = r + "     </gmd:linkage>" + Chr$(13) + Chr$(10)
r = r + "     <gmd:protocol>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>HTTP</gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     </gmd:protocol>" + Chr$(13) + Chr$(10)
r = r + "     <gmd:name>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>Online Resource URL</gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     </gmd:name>" + Chr$(13) + Chr$(10)
r = r + "     <gmd:function>" + Chr$(13) + Chr$(10)
r = r + "     <gmd:CI_OnLineFunctionCode" + Chr$(13) + Chr$(10)
r = r + "       codeList=""{$CDTB}#CI_OnlineFunctionCode""" + Chr$(13) + Chr$(10)
r = r + "       codeListValue=""download"">" + Chr$(13) + Chr$(10)
r = r + "       <xsl:value-of select=""'URL for downloading'""/>" + Chr$(13) + Chr$(10)
r = r + "     </gmd:CI_OnLineFunctionCode>" + Chr$(13) + Chr$(10)
r = r + "     </gmd:function>             " + Chr$(13) + Chr$(10)
r = r + "     </gmd:CI_OnlineResource>" + Chr$(13) + Chr$(10)
r = r + "     </gmd:onLine>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:MD_DigitalTransferOptions>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:transferOptions>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:MD_Distribution>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:distributionInfo>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "  <!-- useless dataQualityInfo -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- portrayalCatalogueInfo -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- metadataConstraints -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- applicationSchemaInfo -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- metadataMaintenance -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- series -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- describes -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- propertyType -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- featureType -->" + Chr$(13) + Chr$(10)
r = r + "  <!-- featureAttribute -->" + Chr$(13) + Chr$(10)
r = r + "  </gmd:MD_Metadata>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template match=""*"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:apply-templates />" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""Constraints-Build"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""TTAAii""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""CodeForm""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""Category""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""ul"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""contains($CodeForm, 'FM51') or contains($CodeForm, 'FM53')"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""'ul=PT12H|'""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""WMO_DataLicenseCode"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:when test=""$Category = 'Essential'"">dl=WMOEssential|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:when test=""$Category = 'Additional'"">dl=WMOAdditional|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:when test=""$Category = 'ICAO'"">dl=WMOOther|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:message terminate=""yes"">" + Chr$(13) + Chr$(10)
r = r + "        <xsl:value-of select=""concat(" + Chr$(13) + Chr$(10)
r = r + "   '@@ malformatted Category (', $Category, ')')""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:message>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""GTSPriority"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:when test=""contains('CN', substring($TTAAii, 1, 1))" + Chr$(13) + Chr$(10)
r = r + "    or ('AA' = substring($TTAAii, 3, 2))"">pr=GTSPriority4|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:when test=""contains('ADEFGHJOPQY', substring($TTAAii, 1, 1))" + Chr$(13) + Chr$(10)
r = r + "    or ('SY' = substring($TTAAii, 1, 2))"">pr=GTSPriority3|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:when test=""contains('IKSTU', substring($TTAAii, 1, 1))" + Chr$(13) + Chr$(10)
r = r + "    or contains(':RR:DA:DQ:'," + Chr$(13) + Chr$(10)
r = r + "   concat(':', substring($TTAAii, 3, 2), ':'))""" + Chr$(13) + Chr$(10)
r = r + "   >pr=GTSPriority2|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:when test=""contains('W', substring($TTAAii, 1, 1))" + Chr$(13) + Chr$(10)
r = r + "    or ('BB' = substring($TTAAii, 1, 4))"">pr=GTSPriority1|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:message>" + Chr$(13) + Chr$(10)
r = r + "        <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "   select=""concat('@@ undefined priority for TTAAii='," + Chr$(13) + Chr$(10)
r = r + "   $TTAAii, ' (3 assumed)')""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:message>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""'pr=3|'""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:value-of select=""concat($ul, $WMO_DataLicenseCode, $GTSPriority)""/>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template match=""contact"">" + Chr$(13) + Chr$(10)
r = r + "  <gmd:CI_ResponsibleParty>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:organisationName>" + Chr$(13) + Chr$(10)
r = r + "      <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""p[k='Organization']/v""/>" + Chr$(13) + Chr$(10)
r = r + "      </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:organisationName>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:positionName>" + Chr$(13) + Chr$(10)
r = r + "      <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""p[k='Role']/v""/>" + Chr$(13) + Chr$(10)
r = r + "      </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:positionName>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:contactInfo>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:CI_Contact>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""p[k='Telephone' or k='Facsimile']"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:phone>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:CI_Telephone>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:if test=""p[k='Telephone']"">" + Chr$(13) + Chr$(10)
r = r + "     <gmd:voice>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of select=""normalize-space(p[k='Telephone']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     </gmd:voice>" + Chr$(13) + Chr$(10)
r = r + "   </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:if test=""p[k='Facsimile']"">" + Chr$(13) + Chr$(10)
r = r + "     <gmd:facsimile>" + Chr$(13) + Chr$(10)
r = r + "     <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     <xsl:value-of select=""normalize-space(p[k='Facsimile']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "     </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "     </gmd:facsimile>" + Chr$(13) + Chr$(10)
r = r + "   </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:CI_Telephone>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:phone>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:address>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:CI_Address>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""p[k='Address']"">" + Chr$(13) + Chr$(10)
r = r + "        <gmd:deliveryPoint>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""normalize-space(p[k='Address']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:deliveryPoint>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""p[k='City']"">" + Chr$(13) + Chr$(10)
r = r + "        <gmd:city>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""normalize-space(p[k='City']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:city>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""p[k='Area']"">" + Chr$(13) + Chr$(10)
r = r + "        <gmd:administrativeArea>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""normalize-space(p[k='Area']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:administrativeArea>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""p[k='Postcode']"">" + Chr$(13) + Chr$(10)
r = r + "        <gmd:postalCode>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""normalize-space(p[k='Postcode']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:postalCode>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""p[k='Country']"">" + Chr$(13) + Chr$(10)
r = r + "        <gmd:country>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""normalize-space(p[k='Country']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:country>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""p[k='email']"">" + Chr$(13) + Chr$(10)
r = r + "        <gmd:electronicMailAddress>" + Chr$(13) + Chr$(10)
r = r + "   <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""normalize-space(p[k='email']/v)""/>" + Chr$(13) + Chr$(10)
r = r + "   </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:electronicMailAddress>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:CI_Address>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:address>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""p[k='web']"">" + Chr$(13) + Chr$(10)
r = r + "   <gmd:onlineResource>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:CI_OnlineResource>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:linkage>" + Chr$(13) + Chr$(10)
r = r + "   <gmd:URL>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""p[k='web']/v""/>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:URL>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:linkage>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:CI_OnlineResource>" + Chr$(13) + Chr$(10)
r = r + "   </gmd:onlineResource>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      </gmd:CI_Contact>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:contactInfo>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:role>" + Chr$(13) + Chr$(10)
r = r + "      <gmd:CI_RoleCode codeList=""{$CDTB}#CI_RoleCode""" + Chr$(13) + Chr$(10)
r = r + "      codeListValue=""pointOfContact"" />" + Chr$(13) + Chr$(10)
r = r + "    </gmd:role>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:CI_ResponsibleParty>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""station-item-keyword"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:if test=""local-name(.) != 'item'"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:message terminate=""yes"">item must be given as .</xsl:message>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:value-of select=""normalize-space(concat(stnid, ' ', name))""/>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""station-item-abstract"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:if test=""local-name(.) != 'item'"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:message terminate=""yes"">item must be given as .</xsl:message>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""parpos"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:if test=""lat or lon or h"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""' ('""/>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""lat""><xsl:value-of select=""lat""/></xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""lon""><xsl:value-of select=""concat(', ', lon)""/></xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:if test=""h""><xsl:value-of select=""concat(', ', h, ' m')""/></xsl:if>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""')'""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:value-of select=""normalize-space(concat(" + Chr$(13) + Chr$(10)
r = r + "  stnid, ' ', name, string($parpos)))""/>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""makeDateProp"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""input""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""pattern""" + Chr$(13) + Chr$(10)
r = r + "    select=""translate($input, '0123456789', '0000000000')""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$pattern = '0000'"">" + Chr$(13) + Chr$(10)
r = r + "    <gco:Date><xsl:value-of select=""concat($input, '-01-01')""/></gco:Date>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$pattern = '0000-00'"">" + Chr$(13) + Chr$(10)
r = r + "    <gco:Date><xsl:value-of select=""concat($input, '-01')""/></gco:Date>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$pattern = '0000-00-00'"">" + Chr$(13) + Chr$(10)
r = r + "    <gco:Date><xsl:value-of select=""$input""/></gco:Date>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$pattern = '0000/00/00'"">" + Chr$(13) + Chr$(10)
r = r + "    <gco:Date><xsl:value-of select=""translate($input, '/', '-')""/></gco:Date>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$pattern = '0000-00-00T00:00:00Z'"">" + Chr$(13) + Chr$(10)
r = r + "    <gco:DateTime><xsl:value-of select=""$input""/></gco:DateTime>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$pattern = '0000-00-00T00:00'"">" + Chr$(13) + Chr$(10)
r = r + "    <gco:DateTime><xsl:value-of select=""$input""/>:00Z</gco:DateTime>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$pattern = '0000-00-00T00:00:00.000'" + Chr$(13) + Chr$(10)
r = r + "    or $pattern = '0000-00-00T00:00:00.00'" + Chr$(13) + Chr$(10)
r = r + "    or $pattern = '0000-00-00T00:00:00.0'"">" + Chr$(13) + Chr$(10)
r = r + "    <gco:DateTime><xsl:value-of select=""substring-before($input, '.')""/>Z</gco:DateTime>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""starts-with($pattern, '0000-00-00T00:00:00')"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:message>@@ unrecognised timezone <xsl:value-of select=""$input""/></xsl:message>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:comment>fake - unrecognised timezone ignored</xsl:comment>" + Chr$(13) + Chr$(10)
r = r + "    <gco:DateTime><xsl:value-of select=""substring($input, 1, 19)""/>Z</gco:DateTime>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$pattern = ''"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:attribute name=""gco:nilReason"">missing</xsl:attribute>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:attribute name=""gco:nilReason"">other:<xsl:value-of select=""$input"" /></xsl:attribute>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:message>@@ makeDate: malformatted date (<xsl:value-of select=""$input""/>)</xsl:message>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""resourceMaintenance"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""TimeGroupP""/>" + Chr$(13) + Chr$(10)
r = r + "  <gmd:resourceMaintenance>" + Chr$(13) + Chr$(10)
r = r + "  <gmd:MD_MaintenanceInformation>" + Chr$(13) + Chr$(10)
r = r + "  <gmd:maintenanceAndUpdateFrequency>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""iso""" + Chr$(13) + Chr$(10)
r = r + "    select=""substring-before(substring-after($TimeGroupP, 'iso='),'|')""/>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:MD_MaintenanceFrequencyCode" + Chr$(13) + Chr$(10)
r = r + "      codeSpace=""ISOTC211/19115""" + Chr$(13) + Chr$(10)
r = r + "      codeList=""{$ISTB}#MD_MaintenanceFrequencyCode""" + Chr$(13) + Chr$(10)
r = r + "      codeListValue=""{$iso}""" + Chr$(13) + Chr$(10)
r = r + "    >" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""$iso""/>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:MD_MaintenanceFrequencyCode>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:maintenanceAndUpdateFrequency>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:if test=""contains($TimeGroupP, '|user=')"">" + Chr$(13) + Chr$(10)
r = r + "    <gmd:userDefinedMaintenanceFrequency>" + Chr$(13) + Chr$(10)
r = r + "      <gts:TM_PeriodDuration>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of" + Chr$(13) + Chr$(10)
r = r + "      select=""substring-before(substring-after($TimeGroupP, '|user='),'|')""/>" + Chr$(13) + Chr$(10)
r = r + "      </gts:TM_PeriodDuration>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:userDefinedMaintenanceFrequency>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:if test=""contains($TimeGroupP, '|times=')"">" + Chr$(13) + Chr$(10)
r = r + "    <gmd:maintenanceNote>" + Chr$(13) + Chr$(10)
r = r + "    <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""normalize-space(concat(" + Chr$(13) + Chr$(10)
r = r + "      'Disseminated at '," + Chr$(13) + Chr$(10)
r = r + "      translate(" + Chr$(13) + Chr$(10)
r = r + "   substring-before(substring-after($TimeGroupP, '|times='), '|')," + Chr$(13) + Chr$(10)
r = r + "   ';', ' '" + Chr$(13) + Chr$(10)
r = r + "      )," + Chr$(13) + Chr$(10)
r = r + "      ' UTC '," + Chr$(13) + Chr$(10)
r = r + "      dataset/p[k='AsNeeded']/v" + Chr$(13) + Chr$(10)
r = r + "    ))""/>" + Chr$(13) + Chr$(10)
r = r + "    </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:maintenanceNote>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:MD_MaintenanceInformation>" + Chr$(13) + Chr$(10)
r = r + "  </gmd:resourceMaintenance>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""TimeGroup-parse"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""TimeGroup""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""   $TimeGroup='continual'   or $TimeGroup='asNeeded'" + Chr$(13) + Chr$(10)
r = r + "      or $TimeGroup='irregular'   or $TimeGroup='notPlanned'" + Chr$(13) + Chr$(10)
r = r + "      or $TimeGroup='unknown'   " + Chr$(13) + Chr$(10)
r = r + "  "">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat('iso=', $TimeGroup, '|')""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='daily'"">iso=daily|user=P1D|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='weekly'"">iso=weekly|user=P7D|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='fortnightly'""" + Chr$(13) + Chr$(10)
r = r + "    >iso=fortnightly|user=P14D|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='monthly'"">iso=monthly|user=P1M|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='quartely'"">iso=quarterly|user=P3M|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='quarterly'"">iso=quarterly|user=P3M|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='biannually'"">iso=biannually|user=P6M|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='annually'"">iso=annually|user=P1Y|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='daily twice'"">iso=continual|user=PT12H|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='daily 3 times'""" + Chr$(13) + Chr$(10)
r = r + "    >iso=continual|user=PT8H|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='daily 4 times'""" + Chr$(13) + Chr$(10)
r = r + "    >iso=continual|user=PT6H|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='daily 8 times'""" + Chr$(13) + Chr$(10)
r = r + "    >iso=continual|user=PT3H|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='daily 12 times'""" + Chr$(13) + Chr$(10)
r = r + "    >iso=continual|user=PT2H|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='hourly'"">iso=continual|user=PT1H|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""starts-with($TimeGroup, 'every')" + Chr$(13) + Chr$(10)
r = r + "  and (substring-after($TimeGroup, 'minute') = 's')" + Chr$(13) + Chr$(10)
r = r + "  and (number(substring-after(substring-before($TimeGroup, 'minutes')," + Chr$(13) + Chr$(10)
r = r + "  'every')) &gt; 0)"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat('iso=continual|user=PT'," + Chr$(13) + Chr$(10)
r = r + "    number(substring-after(substring-before($TimeGroup, 'minutes'), 'every'))," + Chr$(13) + Chr$(10)
r = r + "    'M|')""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$TimeGroup='as available'"">iso=asNeeded|</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""(substring-after($TimeGroup, 'UT') = 'C')" + Chr$(13) + Chr$(10)
r = r + "  and (normalize-space(translate(substring-before($TimeGroup, 'UTC')," + Chr$(13) + Chr$(10)
r = r + "  '0123456789', '')) = '')"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""n"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:call-template name=""word-count"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:with-param name=""s""" + Chr$(13) + Chr$(10)
r = r + "      select=""normalize-space(substring-before($TimeGroup, 'UTC'))""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""h"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 0"">" + Chr$(13) + Chr$(10)
r = r + "        <xsl:message terminate=""yes"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""concat('@@ $TimeGroup('," + Chr$(13) + Chr$(10)
r = r + "   $TimeGroup, ') is empty')""/>" + Chr$(13) + Chr$(10)
r = r + "   </xsl:message>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 1"">PT24H</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 2"">PT12H</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 3"">PT8H</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 4"">PT6H</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 6"">PT4H</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 8"">PT3H</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 12"">PT2H</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 24"">PT1H</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 48"">PT30M</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 72"">PT20M</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 80"">PT18M</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:when test=""$n &lt;= 96"">PT15M</xsl:when>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "        <xsl:message terminate=""yes"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:value-of select=""concat('@@ $TimeGroup('," + Chr$(13) + Chr$(10)
r = r + "   $TimeGroup, ') too busy')""/>" + Chr$(13) + Chr$(10)
r = r + "   </xsl:message>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat(" + Chr$(13) + Chr$(10)
r = r + "      'iso=continual|user=', $h, '|'," + Chr$(13) + Chr$(10)
r = r + "      'times='," + Chr$(13) + Chr$(10)
r = r + "      translate(normalize-space(" + Chr$(13) + Chr$(10)
r = r + "   substring-before($TimeGroup, 'UTC'))" + Chr$(13) + Chr$(10)
r = r + "      , ' ', ';')," + Chr$(13) + Chr$(10)
r = r + "      ';|'" + Chr$(13) + Chr$(10)
r = r + "    )""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:message terminate=""yes"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat('@@ unknown frequency code ('," + Chr$(13) + Chr$(10)
r = r + "      $TimeGroup, ')'" + Chr$(13) + Chr$(10)
r = r + "      )""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:message>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:text>unknown</xsl:text>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""TimeGroup-keyword"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""times""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$times = ''"">" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    <gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "    <gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat('Dissemination '," + Chr$(13) + Chr$(10)
r = r + "      substring-before($times, ';'), 'Z')""/>" + Chr$(13) + Chr$(10)
r = r + "    </gco:CharacterString>" + Chr$(13) + Chr$(10)
r = r + "    </gmd:keyword>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:call-template name=""TimeGroup-keyword"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:with-param name=""times"" select=""substring-after($times, ';')""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""word-count"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""s""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$s = ''"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""0""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""r"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""word-count"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:with-param name=""s"" select=""substring-after($s, ' ')""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""1 + $r""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""make-bbox"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:if test=""local-name(.) != 'bmd'"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:message terminate=""yes"">bmd must be given as .</xsl:message>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:if>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""dataset/p[k='Stations']"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""lat-list"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:for-each select=""dataset/p[k='Stations']/item[lat]"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""coord-number"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:with-param name=""s"" select=""lat""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""' '""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:for-each>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""lon-list"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:for-each select=""dataset/p[k='Stations']/item[lon]"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""coord-number"">" + Chr$(13) + Chr$(10)
r = r + "   <xsl:with-param name=""s"" select=""lon""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""' '""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:for-each>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""wbc"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""list-min"">" + Chr$(13) + Chr$(10)
r = r + "        <xsl:with-param name=""list"" select=""normalize-space($lon-list)""/>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:with-param name=""default"" select=""180""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""ebc"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""list-max"">" + Chr$(13) + Chr$(10)
r = r + "        <xsl:with-param name=""list"" select=""normalize-space($lon-list)""/>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:with-param name=""default"" select=""-180""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""sbc"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""list-min"">" + Chr$(13) + Chr$(10)
r = r + "        <xsl:with-param name=""list"" select=""normalize-space($lat-list)""/>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:with-param name=""default"" select=""90""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""nbc"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""list-max"">" + Chr$(13) + Chr$(10)
r = r + "        <xsl:with-param name=""list"" select=""normalize-space($lat-list)""/>" + Chr$(13) + Chr$(10)
r = r + "   <xsl:with-param name=""default"" select=""-90""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat(" + Chr$(13) + Chr$(10)
r = r + "    '|W=', format-number($wbc, '####.###')," + Chr$(13) + Chr$(10)
r = r + "    '|E=', format-number($ebc, '####.###')," + Chr$(13) + Chr$(10)
r = r + "    '|S=', format-number($sbc, '####.###')," + Chr$(13) + Chr$(10)
r = r + "    '|N=', format-number($nbc, '####.###')," + Chr$(13) + Chr$(10)
r = r + "    '|')""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""concat(" + Chr$(13) + Chr$(10)
r = r + "    '|W=', number(dataset/p[k='West']/v)," + Chr$(13) + Chr$(10)
r = r + "    '|E=', number(dataset/p[k='East']/v)," + Chr$(13) + Chr$(10)
r = r + "    '|S=', number(dataset/p[k='South']/v)," + Chr$(13) + Chr$(10)
r = r + "    '|N=', number(dataset/p[k='North']/v)," + Chr$(13) + Chr$(10)
r = r + "    '|')""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""list-max"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""list""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""default""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$list = ''"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""$default""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""r"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""list-max"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:with-param name=""list"" select=""substring-after($list, ' ')""/>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:with-param name=""default"" select=""$default""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""n"" select=""number(substring-before($list, ' '))""/>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:when test=""$n &gt; $r""><xsl:value-of select=""$n""/></xsl:when>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:otherwise><xsl:value-of select=""$r""/></xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""list-min"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""list""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""default""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""$list = ''"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""$default""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""r"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:call-template name=""list-min"">" + Chr$(13) + Chr$(10)
r = r + "      <xsl:with-param name=""list"" select=""substring-after($list, ' ')""/>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:with-param name=""default"" select=""$default""/>" + Chr$(13) + Chr$(10)
r = r + "      </xsl:call-template>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:variable name=""n"" select=""number(substring-before($list, ' '))""/>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:when test=""$n &lt; $r""><xsl:value-of select=""$n""/></xsl:when>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:otherwise><xsl:value-of select=""$r""/></xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "<xsl:template name=""coord-number"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:param name=""s""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""pat""" + Chr$(13) + Chr$(10)
r = r + "    select=""translate($s, '123456789WESN', '000000000::::')""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""t"" select=""translate($s, 'WESN', '')""/>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:variable name=""sign"">" + Chr$(13) + Chr$(10)
r = r + "  <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""contains($s, 'W') or contains($s, 'S')"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""-1""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""1""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:variable>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:when test=""contains('|0 0:|0 00:|00 0:|00 00:|000 0:|000 00:|dnl" + Chr$(13) + Chr$(10)
r = r + "  |0 0|0 00|00 0|00 00|000 0|000 00|0 00 :|00 00 :|000 00 :|'," + Chr$(13) + Chr$(10)
r = r + "  concat('|', $pat, '|'))"">" + Chr$(13) + Chr$(10)
r = r + "    <xsl:value-of select=""$sign * (number(substring-before($s, ' ')) +" + Chr$(13) + Chr$(10)
r = r + "    number(substring-after($t, ' ')) div 60.0)""/>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:when>" + Chr$(13) + Chr$(10)
r = r + "  <xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "    <xsl:message>" + Chr$(13) + Chr$(10)
r = r + "      <xsl:value-of select=""concat('@@ bad coord (', $s, ')')""/>" + Chr$(13) + Chr$(10)
r = r + "    </xsl:message>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:otherwise>" + Chr$(13) + Chr$(10)
r = r + "  </xsl:choose>" + Chr$(13) + Chr$(10)
r = r + "</xsl:template>" + Chr$(13) + Chr$(10)
r = r + "" + Chr$(13) + Chr$(10)
r = r + "</xsl:stylesheet>" + Chr$(13) + Chr$(10)
sXSLraw2gmd = r
End Function

