Attribute VB_Name = "VBAString"
'
' VBAString.bas - C-like string functions
'
Option Explicit

' --- checks type of the first letter of argument c ---
Function isDigit(c As String) As Boolean
    isDigit = (Asc(c) >= Asc("0") And Asc(c) <= Asc("9"))
End Function

' --- checks type of the first letter of argument c ---
Function isAlpha(c As String) As Boolean
    isAlpha = ( _
        (Asc(c) >= Asc("A") And Asc(c) <= Asc("Z")) Or _
        (Asc(c) >= Asc("a") And Asc(c) <= Asc("z")) _
    )
End Function

' --- same as starts-with() of XSLT ---
Public Function starts_with(q As String, pat As String) As Boolean
  starts_with = (Left(q, Len(pat)) = pat)
End Function


' --- very compromised pattern matching ---
' * pattern is fixed at the beginning, like a regular expression with /^/
' * atmark (@) matches an alphabet [A-Za-z]
' * number (#) matches an digit [0-9]
' * dollar ($) matches end of string (trailing space not ignored)
' * any other letter matches the letter itself
' * no escape to metacharacter
Function stringPattern(str As String, pat As String) As Boolean
    Dim i As Long
    For i = 1 To Len(pat)
        If (Mid$(pat, i, 1) = "@") Then
            If Not isAlpha(Mid$(str, i, 1)) Then GoTo MatchFailed
        ElseIf (Mid$(pat, i, 1) = "#") Then
            If Not isDigit(Mid$(str, i, 1)) Then GoTo MatchFailed
        ElseIf (Mid$(pat, i, 1) = "$") Then
            If Len(Mid$(str, i)) > 0 Then GoTo MatchFailed
        Else
            If (Mid$(pat, i, 1) <> Mid$(str, i, 1)) Then GoTo MatchFailed
        End If
    Next i
    stringPattern = True
    Exit Function
MatchFailed:
    stringPattern = False
    Exit Function
End Function
