use strict;
use warnings;
use XML::LibXML;



my $parser = XML::LibXML->new();
my $doc    = $parser->parse_file($ARGV[0]);

print STDERR $ARGV[0] , "\n";
######################## 
# change dateStamp
# always necessary
########################
my $dateStamp = "//gmd:dateStamp/gco:DateTime/text()";
my($node)  = $doc->findnodes($dateStamp);
$node->setData('2012-01-20T16:00:00');
  
##########################
# change format version
##########################
my $version = "//gmd:MD_Format/gmd:version/gco:CharacterString/text()";
 
 
  my $nodeset = $doc->findnodes($version);
      foreach my $node ($nodeset->get_nodelist) {
		my $verText = $node->to_literal;
		# print STDERR $verText , "\n";
		if ($verText =~ /^[1-9].*/){ 
			my $nver = substr $verText, 1;
			$nver =~ s/^(\s|-)//;
			chomp($nver);
			$nver = trim($nver);
			$node->setData($nver);
		} else {
			$verText =~ s/\?//;
			chomp($verText);
			$verText = trim($verText);
			$node->setData($verText);
		}
	  }

 
###########################
# Fixes ID issue
###########################
  my $dist = "//gmd:distributorContact/gmd:CI_ResponsibleParty";
  my $resp = "//gmd:descriptiveKeywords/*
  /gmd:thesaurusName/*/
  gmd:citedResponsibleParty/gmd:CI_ResponsibleParty";

  $nodeset = $doc->findnodes($dist);
      foreach my $node ($nodeset->get_nodelist) {
		$node->removeAttribute('id');		
    }

$nodeset = $doc->findnodes($resp);
      foreach my $node ($nodeset->get_nodelist) {
		$node->removeAttribute('id');		
    }

##################
# WMOAdditional
##################
my $add = "//gmd:MD_LegalConstraints/gmd:otherConstraints/gco:CharacterString/text()";

$nodeset = $doc->findnodes($add);
      foreach my $node ($nodeset->get_nodelist) {
		my $rights = $node->to_literal;
		$rights =~ s/WMO Additional/WMOAdditional/;
		$node->setData($rights);
		}
		
########################
# Publisher
########################
my $pointOfContactXP = "/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:pointOfContact";
my $pocResp = $pointOfContactXP . "/gmd:CI_ResponsibleParty";
my $mfPub = "/gmd:MD_Metadata/gmd:contact/gmd:CI_ResponsibleParty";

$nodeset = $doc->findnodes($mfPub);
my $n_mfPub;
      foreach my $node ($nodeset->get_nodelist) {
		$n_mfPub = $node;		
    }

$nodeset = $doc->findnodes($pocResp);
my $n_pocResp;
my $deep = 1;
      foreach my $node ($nodeset->get_nodelist) {
		$n_pocResp = $node->cloneNode($deep);	
		$n_pocResp->setAttribute("id", "publisher");
    }

$n_mfPub->replaceNode($n_pocResp);

############################
#   Fix Abstract
#############################
my $abstractXP = "/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:abstract/gco:CharacterString/text()";
$nodeset = $doc->findnodes($abstractXP);
      foreach my $node ($nodeset->get_nodelist) {
		my $abstract = $node->to_literal;
		
		$abstract =~ s/(.*)(---- Please review:.*)/$1/s;
		$abstract = trim($abstract);
		
		$node->setData($abstract);
		}



############################
#   Print Document
#############################
print $doc->toString;
  
sub trim {
	my @out = @_;
	for (@out) {
		s/^\s+//;
		s/\s+$//;
	}
	return wantarray ? @out : $out[0];
}