<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="urn:oasis:names:tc:emergency:cap:1.2"
  xmlns:jx="http://xml.kishou.go.jp/jmaxml1/"
  xmlns:jb="http://xml.kishou.go.jp/jmaxml1/informationBasis1/"
  xmlns:jm="http://xml.kishou.go.jp/jmaxml1/body/meteorology1/"
  xmlns:je="http://xml.kishou.go.jp/jmaxml1/elementBasis1/"
  xmlns:fn="http://exslt.org/functions"
  extension-element-prefixes="fn"
  exclude-result-prefixes="jx jb jm je fn"
>

<!-- taken from https://bitbucket.org/vaporoid/vaporoid-hash  -->
<xsl:import href="vaporoid-hash.xsl"/>

<xsl:output method="xml" version="1.0" encoding="UTF-8"
  omit-xml-declaration="no" indent="yes"/>

<xsl:param name="STATUS_ACTUAL" select="'Actual'"/>
<xsl:param name="EMAIL" select="'rsmc-tokyo@met.kishou.go.jp'"/>
<xsl:param name="WEB" select="'http://www.jma.go.jp/en/typh/index.html'"/>
<xsl:param name="FTFILTER"
  select="'|AN|FT 24HRS|FT 45HRS|FT 48HRS|FT 69HRS|FT 72HRS|EXFT 96HRS|EXFT 120HRS|'"/>
<xsl:param name="TESTCONV" select="''"/>

<xsl:template match="/">
  <xsl:variable name="tl">
    <xsl:apply-templates select="jx:Report/jx:Control[1]/jx:Title[1]"/>
  </xsl:variable>
  <xsl:choose>
  <xsl:when test="($tl = 'VPTW5i') and ($TESTCONV = '')">
    <xsl:apply-templates select="jx:Report">
      <xsl:with-param name="myFTFILTER" select="'|EXFT 96HRS|EXFT 120HRS|'"/>
    </xsl:apply-templates>
  </xsl:when>
  <xsl:otherwise>
    <xsl:apply-templates select="jx:Report">
      <xsl:with-param name="myFTFILTER" select="$FTFILTER"/>
    </xsl:apply-templates>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="jx:Report" mode="uuid">
  <xsl:param name="myFTFILTER" select="$FTFILTER"/>
  <!-- making variables -->
  <xsl:variable name="tl">
    <xsl:apply-templates select="jx:Control[1]/jx:Title[1]"/>
  </xsl:variable>
  <xsl:variable name="eo">
    <xsl:apply-templates select="jx:Control[1]/jx:EditorialOffice[1]"/>
  </xsl:variable>
  <xsl:variable name="st">
    <xsl:apply-templates select="jx:Control[1]/jx:Status[1]"/>
  </xsl:variable>
  <xsl:variable name="senttime">
    <xsl:apply-templates select="jx:Control[1]/jx:DateTime[1]"/>
  </xsl:variable>
  <xsl:variable name="EventID">
    <xsl:value-of select="normalize-space(jb:Head/jb:EventID)"/>
  </xsl:variable>
  <xsl:variable name="taguri" select="concat(
      'tag:', $EMAIL, ',2012-04-01:', $tl, ':', $eo, ':',
      $st, ':', $EventID, ':',
      translate($myFTFILTER, '| ', '_'), ':',
      translate(substring-before($senttime, '|'), ':', '_')
  )"/>
  <xsl:message><xsl:value-of select="$taguri"/></xsl:message>
  <xsl:variable name="md5"
    xmlns:vaporoid-hash="http://vaporoid.com/vaporoid-hash">
    <xsl:call-template name="vaporoid-hash:md5">
      <xsl:with-param name="string" select="$taguri"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:value-of select="concat(
    substring($md5, 1, 8), '-',
    substring($md5, 9, 4), '-3',
    substring($md5, 14, 3), '-',
    translate(substring($md5, 17, 1), '0123456789abcdef', '89ab89ab89ab89ab'),
    substring($md5, 18, 3), '-',
    substring($md5, 21, 12)
  )"/>
</xsl:template>

<xsl:template match="jx:Report">
  <xsl:param name="myFTFILTER" select="$FTFILTER"/>
  <xsl:variable name="uuid">
    <xsl:apply-templates select="." mode="uuid">
      <xsl:with-param name="myFTFILTER" select="$myFTFILTER"/>
    </xsl:apply-templates>
  </xsl:variable>
  <xsl:variable name="senttime">
    <xsl:apply-templates select="jx:Control[1]/jx:DateTime[1]"/>
  </xsl:variable>
  <xsl:variable name="effectiveTime">
    <xsl:apply-templates select="jb:Head[1]/jb:ReportDateTime[1]"/>
  </xsl:variable>
  <xsl:variable name="EventID">
    <xsl:value-of select="normalize-space(jb:Head/jb:EventID)"/>
  </xsl:variable>
  <xsl:variable name="NAMEPART">
    <xsl:apply-templates select="jm:Body/jm:MeteorologicalInfos
    /jm:MeteorologicalInfo/jm:Item/jm:Kind/jm:Property/jm:TyphoonNamePart"/>
  </xsl:variable>
<alert>
  <identifier><xsl:value-of select="$uuid"/></identifier>
  <sender><xsl:value-of select="$EMAIL"/></sender>
  <sent><xsl:value-of select="substring-before($senttime, '|')"/></sent>
  <status>
    <xsl:apply-templates select="jx:Control[1]/jx:Status[1]"/>
  </status>
  <msgType>Alert</msgType>
  <!-- may not suitable for public display, but dissemination not restricted -->
  <scope>Public</scope>
  <code><xsl:comment>vptw2cap.xsl $Revision: 1.82 $</xsl:comment>CAP-RSMCTK</code>
  <xsl:for-each
  select="jm:Body/jm:MeteorologicalInfos/jm:MeteorologicalInfo">
    <xsl:variable name="validtime">
      <xsl:apply-templates select="jm:DateTime[1]"/>
    </xsl:variable>
    <xsl:variable name="fttype" select="substring-after($validtime, '|')"/>
    <xsl:if test="contains($myFTFILTER,concat('|',$fttype,'|'))">

      <xsl:variable name="ft"
      select="number(translate($fttype, 'ANEXFTHRS', '0'))"/>
      <xsl:variable name="COREPART">
        <xsl:value-of select="concat('|ft=', $ft, '|')"/>
	<xsl:apply-templates
	  select="jm:Item/jm:Kind/jm:Property[jm:Type='階級']/jm:ClassPart"/>
	<xsl:apply-templates
	  select="jm:Item/jm:Kind/jm:Property[jm:Type='中心']/jm:CenterPart[1]"/>
	<xsl:apply-templates
	  select="jm:Item/jm:Kind/jm:Property[jm:Type='風']/jm:WindPart[1]"/>

      </xsl:variable>
      <xsl:variable name="STORMAREA">
        <xsl:apply-templates select="jm:Item/jm:Kind/jm:Property[jm:Type='風']
	/jm:WarningAreaPart[@type='暴風域']">
	  <xsl:with-param name="LALO" select="fn:extract($COREPART, 'LALO')"/>
	</xsl:apply-templates>
      </xsl:variable>
      <xsl:variable name="GALEAREA">
        <xsl:apply-templates select="jm:Item/jm:Kind/jm:Property[jm:Type='風']
	/jm:WarningAreaPart[@type='強風域']">
	  <xsl:with-param name="LALO" select="fn:extract($COREPART, 'LALO')"/>
	</xsl:apply-templates>
      </xsl:variable>
      <info>
	<category>Met</category>
	<event>
	  <xsl:choose>
	  <xsl:when test="$ft = 0"
	  >TROPICAL CYCLONE ADVISORY/ANALYSIS</xsl:when>
	  <xsl:otherwise
	  >TROPICAL CYCLONE ADVISORY/FORECAST</xsl:otherwise>
	  </xsl:choose>
	</event>
	<urgency>Unknown</urgency>
	<severity>Unknown</severity>
	<certainty>Observed</certainty>
	<eventCode>
	  <valueName>EventType</valueName>
	  <value>
	  <xsl:choose>
	  <xsl:when test="$ft = 0">TC_Analysis</xsl:when>
	  <xsl:otherwise><xsl:value-of
	  select="concat('TC_Forecast', $ft)"
	  /></xsl:otherwise>
	  </xsl:choose>
	  </value>
	</eventCode>
	<eventCode>
	  <xsl:comment> CAUTION:
	  this number is to collate a depression,
	  not to be confused with number associated with name.
	  </xsl:comment>
	  <valueName>TC_Number</valueName>
	  <value>
	    <!-- remove 'TC' at the head of $EventID -->
	    <xsl:value-of select="translate($EventID, 'TC', '')"/>
	  </value>
	</eventCode>
	<xsl:if test="fn:extract($NAMEPART, 'remark') != ''">
	  <eventCode>
	  <valueName>TC_Remark</valueName>
	  <value>
	    <xsl:value-of select="fn:extract($NAMEPART, 'remark')"/>
	  </value>
	  </eventCode>
	</xsl:if>
	<effective>
	  <xsl:value-of select="substring-before($effectiveTime, '|')"/>
	</effective>
	<onset>
	  <xsl:value-of select="substring-before($validtime, '|')"/>
	</onset>
	<expires>
	  <xsl:call-template name="datetime_add">
	    <xsl:with-param name="t"
	    select="substring-before($validtime, '|')"/>
	    <xsl:with-param name="dt" select="'06:00'"/>
	  </xsl:call-template>
	</expires>
	<senderName>RSMC Tokyo - Typhoon Center</senderName>
	<headline>
	  <xsl:call-template name="headline">
	    <xsl:with-param name="validtime" select="$validtime"/>
	    <xsl:with-param name="NAMEPART" select="$NAMEPART"/>
	    <xsl:with-param name="COREPART" select="$COREPART"/>
	    <xsl:with-param name="GALEAREA" select="$GALEAREA"/>
	    <xsl:with-param name="STORMAREA" select="$STORMAREA"/>
	  </xsl:call-template>
	</headline>
	<description>
	  <xsl:call-template name="description">
	    <xsl:with-param name="validtime" select="$validtime"/>
	    <xsl:with-param name="NAMEPART" select="$NAMEPART"/>
	    <xsl:with-param name="COREPART" select="$COREPART"/>
	    <xsl:with-param name="GALEAREA" select="$GALEAREA"/>
	    <xsl:with-param name="STORMAREA" select="$STORMAREA"/>
	  </xsl:call-template>
	</description>
	<web><xsl:value-of select="$WEB"/></web>
	<!-- parameters -->
	<xsl:if test="contains($COREPART, '|kaikyuu=')">
	  <parameter>
	    <valueName>TC_Classification</valueName>
	    <value><xsl:value-of select="fn:extract($COREPART, 'kaikyuu')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($NAMEPART, 'name') != ''">
	  <parameter>
	    <valueName>TC_CycloneName</valueName>
	    <value><xsl:value-of select="fn:extract($NAMEPART, 'name')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($NAMEPART, 'number') != ''">
	  <parameter>
	    <valueName>TC_CycloneID</valueName>
	    <value><xsl:value-of select="fn:extract($NAMEPART, 'number')"/></value>
	  </parameter>
	</xsl:if>
	<parameter>
	  <valueName>TC_MovingDirection</valueName>
	  <value>
	    <xsl:value-of select="fn:extract($COREPART, 'MVDIR')"/>
	  </value>
	</parameter>
	<parameter>
	  <valueName>TC_MovingSpeed</valueName>
	  <value>
	    <xsl:value-of select="fn:extract($COREPART, 'MVSPD')"/>
	  </value>
	</parameter>
	<xsl:if test="fn:extract($COREPART, 'CFID') != ''">
	  <parameter>
	    <valueName>TC_PositionConfidence</valueName>
	    <value>
	    <xsl:value-of select="fn:extract($COREPART, 'CFID')"/>
	    </value>
	  </parameter>
	</xsl:if>
	<!-- wind -->
	<xsl:if test="fn:extract($COREPART, 'PRES') != ''">
	  <parameter>
	    <valueName>TC_CenterPressure</valueName>
	    <value><xsl:value-of select="fn:extract($COREPART, 'PRES')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($COREPART, 'LOC') != ''">
	  <parameter>
	    <valueName>TC_Location</valueName>
	    <value><xsl:value-of select="fn:extract($COREPART, 'LOC')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($COREPART, 'MXWD') != ''">
	  <parameter>
	    <valueName>TC_MaxSustainedWind</valueName>
	    <value><xsl:value-of select="fn:extract($COREPART, 'MXWD')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($COREPART, 'GUST') != ''">
	  <parameter>
	    <valueName>TC_PeakGust</valueName>
	    <value><xsl:value-of select="fn:extract($COREPART, 'GUST')"/></value>
	  </parameter>
	</xsl:if>
	<!-- gale radius -->
	<xsl:if test="fn:extract($GALEAREA, 'XRAD') != ''">
	  <parameter>
	    <valueName>TC_MaxGaleRadius</valueName>
	    <value><xsl:value-of select="fn:extract($GALEAREA, 'XRAD')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($GALEAREA, 'XDIR') != ''">
	  <parameter>
	    <valueName>TC_MaxGaleRadiusDirection</valueName>
	    <value><xsl:value-of select="fn:extract($GALEAREA, 'XDIR')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($GALEAREA, 'NRAD') != ''">
	  <parameter>
	    <valueName>TC_MinGaleRadius</valueName>
	    <value><xsl:value-of select="fn:extract($GALEAREA, 'NRAD')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($GALEAREA, 'NDIR') != ''">
	  <parameter>
	    <valueName>TC_MinGaleRadiusDirection</valueName>
	    <value><xsl:value-of select="fn:extract($GALEAREA, 'NDIR')"/></value>
	  </parameter>
	</xsl:if>
	<!-- storm radius -->
	<xsl:if test="fn:extract($STORMAREA, 'XRAD') != ''">
	  <parameter>
	    <valueName>TC_MaxStormRadius</valueName>
	    <value><xsl:value-of select="fn:extract($STORMAREA, 'XRAD')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($STORMAREA, 'XDIR') != ''">
	  <parameter>
	    <valueName>TC_MaxStormRadiusDirection</valueName>
	    <value><xsl:value-of select="fn:extract($STORMAREA, 'XDIR')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($STORMAREA, 'NRAD') != ''">
	  <parameter>
	    <valueName>TC_MinStormRadius</valueName>
	    <value><xsl:value-of select="fn:extract($STORMAREA, 'NRAD')"/></value>
	  </parameter>
	</xsl:if>
	<xsl:if test="fn:extract($STORMAREA, 'NDIR') != ''">
	  <parameter>
	    <valueName>TC_MinStormRadiusDirection</valueName>
	    <value><xsl:value-of select="fn:extract($STORMAREA, 'NDIR')"/></value>
	  </parameter>
	</xsl:if>
	<parameter>
	  <valueName>UUID</valueName>
	  <value>
	    <xsl:apply-templates select="../../.." mode="uuid">
	      <xsl:with-param name="myFTFILTER" select="$ft"/>
	    </xsl:apply-templates>
	  </value>
	</parameter>
	<xsl:if test="fn:extract($GALEAREA, 'circle') != ''">
	  <area>
	    <xsl:comment>Gale warning</xsl:comment>
	    <areaDesc/>
	    <circle>
	      <xsl:value-of select="fn:extract($GALEAREA, 'circle')"/>
	    </circle>
	  </area>
	</xsl:if>
	<xsl:if test="fn:extract($STORMAREA, 'circle') != ''">
	  <area>
	    <xsl:comment>Storm warning</xsl:comment>
	    <areaDesc/>
	    <circle>
	      <xsl:value-of select="fn:extract($STORMAREA, 'circle')"/>
	    </circle>
	  </area>
	</xsl:if>
	<area>
	  <areaDesc>
	    <xsl:value-of select="fn:extract($COREPART, 'AREA')"/>
	  </areaDesc>
	  <circle>
	    <xsl:value-of select="concat(
	    translate(fn:extract($COREPART,'LALO'), ' ', ','), ' ',
	    fn:extract($COREPART, 'FR'))"/>
	  </circle>
	</area>
      </info>

    </xsl:if>
  </xsl:for-each>
</alert>
</xsl:template>

<xsl:template name="headline">
  <xsl:param name="validtime"/>
  <xsl:param name="NAMEPART"/>
  <xsl:param name="COREPART"/>
  <xsl:param name="GALEAREA"/>
  <xsl:param name="STORMAREA"/>
  <xsl:variable name="TcId">
    <xsl:if test="contains($NAMEPART, '|name=')">
      <xsl:value-of select="concat(
	fn:extract($NAMEPART, 'name'), ' (',
	fn:extract($NAMEPART, 'number'), ')')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="remark" select="fn:extract($NAMEPART, 'remark')"/>
  <xsl:variable name="cname" select="fn:extract($NAMEPART, 'cname')"/>
  <xsl:variable name="Subject">
    <xsl:choose>
    <xsl:when test="$remark = 'U'">
      <xsl:value-of select="concat('new ', $cname, ' ', $TcId)"/>
    </xsl:when>
    <xsl:when test="contains('|D|L|I|O|', concat('|', $remark, '|'))">
      <xsl:value-of select="concat($TcId, ' became ', $cname)"/>
    </xsl:when>
    <xsl:when test="$remark = 'UCancel'">
      <xsl:value-of select="concat($cname, ' no longer upgrading')"/>
    </xsl:when>
    <xsl:when test="$remark = 'UWill'">
      <xsl:value-of select="concat($cname, ' expected upgrading')"/>
    </xsl:when>
    <xsl:when test="$remark = 'LWill'">
      <xsl:value-of select="concat($cname, ' ', $TcId, ' becoming LOW')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="concat($cname, ' ', $TcId)"/>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="PRES">
    <xsl:if test="fn:extract($COREPART, 'PRES') != ''">
      <xsl:value-of select="concat(
        'PRES ', fn:extract($COREPART, 'PRES'), ' ')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="CHANGE">
    <xsl:variable name="kaikyuu" select="fn:extract($COREPART, 'kaikyuu')"/>
    <xsl:if test="not($cname = $kaikyuu) and ($kaikyuu != '')">
      <xsl:value-of select="concat('TOBE ', $kaikyuu, ' ')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="MXWD">
    <xsl:if test="fn:extract($COREPART, 'MXWD') != ''">
      <xsl:value-of select="concat(
        'MXWD ', fn:extract($COREPART, 'MXWD'), ' ')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="GUST">
    <xsl:if test="fn:extract($COREPART, 'GUST') != ''">
      <xsl:value-of select="concat(
        'GUST ', fn:extract($COREPART, 'GUST'), ' ')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="GALE">
    <xsl:if test="fn:extract($GALEAREA, 'headline') != ''">
      <xsl:value-of
      select="concat('GALE ', fn:extract($GALEAREA, 'headline'), ' ')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="STORM">
    <xsl:if test="fn:extract($STORMAREA, 'headline') != ''">
      <xsl:value-of
      select="concat('STORM ', fn:extract($STORMAREA, 'headline'), ' ')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="MOV">
    <xsl:value-of select="concat(
    'MOVE ', fn:extract($COREPART, 'MVDIR'), ' ',
    fn:extract($COREPART, 'MVSPD'), ' ')"/>
  </xsl:variable>
  <xsl:variable name="CFID">
    <xsl:if test="fn:extract($COREPART, 'CFID') != ''">
    <xsl:value-of select="concat(fn:extract($COREPART, 'CFID'), ' ')"/>
    </xsl:if>
    <xsl:if test="fn:extract($COREPART, 'FR') != '0'">
    <xsl:value-of select="concat(' &#177;',
    fn:extract($COREPART, 'FR'), ' km ')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="result">
    <xsl:value-of select="normalize-space(concat(
      $Subject, ' ',
      jm:HeadlineTime($validtime), ': ',
      jm:HeadlineLalo(fn:extract($COREPART,'LALO')), ' ',
      $CFID, $MOV,
      $PRES, $CHANGE, $MXWD, $GUST, $GALE, $STORM))"/>
  </xsl:variable>
  <xsl:choose>
  <xsl:when test="string-length($result) &gt; 139">
    <xsl:value-of select="concat(substring($result, 1, 138), '&#8230;')"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of select="$result"/>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="description">
  <xsl:param name="validtime"/>
  <xsl:param name="NAMEPART"/>
  <xsl:param name="COREPART"/>
  <xsl:param name="GALEAREA"/>
  <xsl:param name="STORMAREA"/>
  <xsl:variable name="TcId">
    <xsl:if test="contains($NAMEPART, '|name=')">
      <xsl:value-of select="concat(
	fn:extract($NAMEPART, 'name'), ' (',
	fn:extract($NAMEPART, 'number'), ')')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="remark" select="fn:extract($NAMEPART, 'remark')"/>
  <xsl:variable name="cname" select="fn:extract($NAMEPART, 'cname')"/>
  <xsl:variable name="Subject">
    <xsl:choose>
    <xsl:when test="$remark = 'U'">
      <xsl:value-of select="concat('newly upgraded ', $cname, ' ', $TcId)"/>
    </xsl:when>
    <xsl:when test="contains('|D|L|I|O|', concat('|', $remark, '|'))">
      <xsl:value-of select="concat($TcId, ' became ',
      jm:SpellTyphoonClass($cname))"/>
    </xsl:when>
    <xsl:when test="$remark = 'UCancel'">
      <xsl:value-of select="concat($cname, ' no longer upgrading')"/>
    </xsl:when>
    <xsl:when test="$remark = 'UWill'">
      <xsl:value-of select="concat($cname, ' expected upgrading')"/>
    </xsl:when>
    <xsl:when test="$remark = 'LWill'">
      <xsl:value-of select="concat($cname, ' ', $TcId,
      ' becoming extratropical LOW')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="concat(jm:SpellTyphoonClass($cname), ' ', $TcId)"/>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="PRES">
    <xsl:if test="fn:extract($COREPART, 'PRES') != ''">
      <xsl:value-of select="concat('Pressure ',
        fn:extract($COREPART, 'PRES'), '&#10;')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="MXWD">
    <xsl:if test="fn:extract($COREPART, 'MXWD') != ''">
      <xsl:value-of select="concat(
        'Max winds ', jm:SpellKnot(fn:extract($COREPART, 'MXWD')),
	'.&#10;')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="GUST">
    <xsl:if test="fn:extract($COREPART, 'GUST') != ''">
      <xsl:value-of select="concat(
        'Gust ', jm:SpellKnot(fn:extract($COREPART, 'GUST')),
	'.&#10;')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="CHANGE">
    <xsl:variable name="kaikyuu" select="fn:extract($COREPART, 'kaikyuu')"/>
    <xsl:if test="not($cname = $kaikyuu) and ($kaikyuu != '')">
      <xsl:value-of select="concat('Expected to be ',
      jm:SpellTyphoonClass($kaikyuu), '.&#10;')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="GALE">
    <xsl:if test="fn:extract($GALEAREA, 'description') != ''">
      <xsl:value-of
      select="concat('Gale radius ', fn:extract($GALEAREA, 'description'),
      '.&#10;')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="STORM">
    <xsl:if test="fn:extract($STORMAREA, 'description') != ''">
      <xsl:value-of
      select="concat('Storm radius ', fn:extract($STORMAREA, 'description'),
      '.&#10;')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="MOV">
    <xsl:value-of select="concat(
    'Moving ', jm:SpellDirection(fn:extract($COREPART, 'MVDIR')), ' ',
    jm:SpellKnot(fn:extract($COREPART, 'MVSPD')), '.&#10;')"/>
  </xsl:variable>
  <xsl:variable name="CFID">
    <xsl:variable name="c" select="fn:extract($COREPART, 'CFID')"/>
    <xsl:if test="$c != ''">
      <xsl:variable name="cd">
        <xsl:choose>
	<xsl:when test="$c = 'POOR'"> (radius more than 110 km)</xsl:when>
	<xsl:when test="$c = 'FAIR'"> (radius of 55 to 110 km)</xsl:when>
	<xsl:when test="$c = 'GOOD'"> (radius of 55 km or less)</xsl:when>
	</xsl:choose>
      </xsl:variable>
      <xsl:value-of select="concat(
      'position ', fn:extract($COREPART, 'CFID'), $cd, '.&#10;')"/>
    </xsl:if>
    <xsl:if test="fn:extract($COREPART, 'FR') != '0'">
    <xsl:value-of select="concat(
    'with ', fn:extract($COREPART, 'FR'),
    ' km of 70 percent probability circle.&#10;')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:value-of select="concat(
    $Subject, '&#10;',
    jm:HeadlineTime($validtime, 'Forecast', ' hr'), ':&#10;',
    $PRES,
    'at ', jm:DescriptionLalo(fn:extract($COREPART,'LALO')), '&#10;',
    $CFID, $MOV, $MXWD, $GUST, $CHANGE, $GALE, $STORM)"/>
</xsl:template>

<fn:function name="jm:SpellTyphoonClass">
  <xsl:param name="cname"/>
  <fn:result>
  <xsl:choose>
  <xsl:when test="$cname = 'LOW'">EXTRA-TROPICAL LOW</xsl:when>
  <xsl:when test="$cname = 'TD'">TROPICAL DEPRESSION</xsl:when>
  <xsl:when test="$cname = 'TS'">TROPICAL STORM</xsl:when>
  <xsl:when test="$cname = 'STS'">SEVERE TROPICAL STORM</xsl:when>
  <xsl:when test="$cname = 'TY'">TYPHOON</xsl:when>
  <xsl:otherwise><xsl:value-of select="$cname"/></xsl:otherwise>
  </xsl:choose>
  </fn:result>
</fn:function>

<fn:function name="jm:HeadlineLalo">
  <xsl:param name="lalo"/>
  <xsl:variable name="lat" select="substring-before($lalo, ' ')"/>
  <xsl:variable name="lon" select="substring-after($lalo, ' ')"/>
  <xsl:variable name="sgnlat"
    select="substring(translate($lat, '-0123456789.', 'SNNNNNNNNNNN'), 1, 1)"/>
  <xsl:variable name="sgnlon"
    select="substring(translate($lat, '-0123456789.', 'WEEEEEEEEEEE'), 1, 1)"/>
  <xsl:variable name="abslat" select="translate($lat, '-', '')"/>
  <xsl:variable name="abslon" select="translate($lon, '-', '')"/>
  <fn:result>
    <xsl:value-of select="concat($abslat, '&#176;', $sgnlat, ' ',
      $abslon, '&#176;', $sgnlon)"/>
  </fn:result>
</fn:function>

<fn:function name="jm:DescriptionLalo">
  <xsl:param name="lalo"/>
  <xsl:variable name="lat" select="substring-before($lalo, ' ')"/>
  <xsl:variable name="lon" select="substring-after($lalo, ' ')"/>
  <xsl:variable name="sgnlat"
    select="substring(translate($lat, '-0123456789.', 'SNNNNNNNNNNN'), 1, 1)"/>
  <xsl:variable name="sgnlon"
    select="substring(translate($lat, '-0123456789.', 'WEEEEEEEEEEE'), 1, 1)"/>
  <xsl:variable name="abslat" select="translate($lat, '-', '')"/>
  <xsl:variable name="abslon" select="translate($lon, '-', '')"/>
  <fn:result>
    <xsl:value-of select="concat(
    $abslat, ' degree ', jm:SpellDirection($sgnlat), ' ',
    $abslon, ' degree ', jm:SpellDirection($sgnlon))"/>
  </fn:result>
</fn:function>

<fn:function name="jm:HeadlineTime">
  <xsl:param name="validtime"/>
  <xsl:param name="fcst" select="'FCST'"/>
  <xsl:param name="h" select="'h'"/>
  <xsl:variable name="t" select="substring-after($validtime, '|')"/>
  <xsl:variable name="ftname">
    <xsl:choose>
    <xsl:when test="starts-with($t, 'AN')">ANALYSIS</xsl:when>
    <xsl:when test="starts-with($t, 'FT ')">
      <xsl:value-of select="concat($fcst, ' ',
      translate(substring-after($t, 'FT '), 'HRS', $h))"/>
    </xsl:when>
    <xsl:when test="starts-with($t, 'EXFT ')">
      <xsl:value-of select="concat($fcst, ' ',
      translate(substring-after($t, 'EXFT '), 'HRS', 'h'))"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:message terminate="yes">UNEXPECTED Time [<xsl:value-of
      select="$t"/>]</xsl:message>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <fn:result>
    <xsl:value-of select="concat($ftname, ' (',
      substring($validtime, 9, 2),
      substring($validtime, 12, 2),
      'UTC)')"/>
  </fn:result>
</fn:function>

<xsl:template match="jx:Title">
  <xsl:choose>
  <xsl:when test="text() = '台風解析・予報情報（３日予報）'">VPTW4i</xsl:when>
  <xsl:when test="text() = '台風解析・予報情報（５日予報）'">VPTW5i</xsl:when>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('Unsupported Title (',text(),')')"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="jx:EditorialOffice">
  <xsl:choose>
  <xsl:when test="text() = '気象庁本庁'">RJTD</xsl:when>
  <!-- いまのところはあくまで例 -->
  <xsl:when test="text() = '大阪管区気象台'">JPOS</xsl:when>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('Unsupported EditorialOffice (',text(),')')"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="jx:Status">
  <xsl:choose>
  <xsl:when test="text()='通常'">
    <xsl:value-of select="$STATUS_ACTUAL"/>
  </xsl:when>
  <xsl:when test="text()='訓練'">
    <xsl:value-of select="'Excercise'"/>
  </xsl:when>
  <xsl:when test="text()='試験'">
    <xsl:value-of select="'Test'"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:message terminate="yes"><xsl:value-of select="concat(
      'unsupported Status (', text(), ')'
    )"/></xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="jm:DateTime|jx:DateTime|jb:ReportDateTime">
  <xsl:variable name="pat">
    <xsl:call-template name="flatten_digits">
      <xsl:with-param name="string" select="text()"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="main">
    <xsl:choose>
    <xsl:when test="$pat = '9999-99-99T99:99:99+99:99'">
      <xsl:call-template name="datetime_add">
        <xsl:with-param name="t" select="text()"/>
	<xsl:with-param name="dt" select="'00:00'"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="$pat = '9999-99-99T99:99:99Z'">
      <xsl:value-of select="concat(substring-before(text(), 'Z'), '+00:00')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:message terminate="yes"><xsl:value-of select="concat(
	'unsupported DateTime format [', text(), ']'
      )"/></xsl:message>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="dtype" select="
      translate(@type,
      '実況延長予報時間後推定０１２３４５６７８９　',
      'ANEXFTHRSES0123456789 ')
  "/>
  <xsl:value-of select="concat($main,'|',$dtype)"/>
</xsl:template>

<xsl:template match="jm:TyphoonNamePart">
  <xsl:variable name="name">
    <xsl:if test="jm:Name != ''">
      <xsl:value-of select="concat('name=', jm:Name, '|')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="cname">
    <xsl:variable name="KAIKYUU">
      <xsl:apply-templates
      select="../../../jm:Kind/jm:Property[jm:Type='階級']/jm:ClassPart"/>
    </xsl:variable>
    <xsl:value-of select="concat('cname=',
      fn:extract($KAIKYUU, 'kaikyuu'), '|')"/>
  </xsl:variable>
  <xsl:variable name="number">
    <xsl:if test="jm:Number != ''">
      <xsl:value-of select="concat('number=', jm:Number, '|')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="remark">
    <xsl:variable name="remark-map">
    |台風発生=U|
    |台風発生（域外から入る）=I|
    |台風消滅（域外へ出る）=O|
    |台風消滅（温帯低気圧化）=L|
    |台風消滅（熱帯低気圧化）=D|
    |台風発生の可能性が小さくなった=UCancel|
    |台風発生予想=UWill|
    |温帯低気圧化しつつある=LWill|
    |発表間隔変更（毎時から３時間毎）=C3|
    |発表間隔変更（３時間毎から毎時）=C1|
    </xsl:variable>
    <xsl:if test="jm:Remark != ''">
    <xsl:value-of select="concat('remark=', fn:extract($remark-map, jm:Remark), '|')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:value-of select="concat('|', $name, $cname, $number, $remark)"/>
</xsl:template>

<xsl:template match="jm:CenterPart">
  <xsl:variable name="LALO">
    <xsl:choose>
    <xsl:when test="je:Coordinate">
      <xsl:apply-templates select="je:Coordinate[@type='中心位置（度）']"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates
      select="jm:ProbabilityCircle[1]/je:BasePoint[@type='中心位置（度）']"/>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="FR">
    <xsl:choose>
    <xsl:when test="jm:ProbabilityCircle">
      <xsl:value-of
      select="number(jm:ProbabilityCircle//je:Radius[@unit='km'])"
      />
    </xsl:when>
    <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="PRES">
    <xsl:apply-templates select="je:Pressure"/>
  </xsl:variable>
  <xsl:variable name="MVDIR">
    <xsl:apply-templates select="je:Direction[@type='移動方向']">
      <xsl:with-param name="undef" select="''"/>
    </xsl:apply-templates>
  </xsl:variable>
  <xsl:variable name="MVSPD">
    <xsl:apply-templates select="je:Speed[@type='移動速度'][@unit='ノット']">
      <xsl:with-param name="use-condition" select="true()"/>
    </xsl:apply-templates>
  </xsl:variable>
  <xsl:variable name="CFID">
    <xsl:apply-templates select="je:Coordinate[1]" mode="confidence"/>
  </xsl:variable>
  <xsl:variable name="LOC">
    <xsl:apply-templates select="jm:Location[1]/text()"/>
  </xsl:variable>
  <xsl:variable name="AREA">
    <xsl:call-template name="LALOtoAREA">
      <xsl:with-param name="LALO" select="$LALO"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:value-of select="concat(
    '|LALO=', $LALO,
    '|FR=', $FR,
    '|PRES=', $PRES,
    '|MVDIR=', $MVDIR,
    '|MVSPD=', $MVSPD,
    '|CFID=', $CFID,
    '|AREA=', $AREA,
    '|LOC=', $LOC,
  '|')"/>
</xsl:template>

<xsl:key name="kvpick" match="p" use="@k"/>

<xsl:template name="LALOtoAREA">
  <xsl:param name="LALO" />
  <xsl:variable name="LL" select="concat(
    '+', format-number(floor(substring-before($LALO, ' ')), '00'),
    '+', format-number(floor(substring-after($LALO, ' ')), '000'), '/'
  )"/>
  <xsl:variable name="map">
    <xsl:for-each select="document('vloc.xml')/kv">
      <xsl:variable name="a" select="key('kvpick', $LL)/@v" />
      <xsl:for-each select="document('vloc2.xml')/hash">
        <xsl:value-of select="key('kvpick', $a)/@en"/>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:variable>
  <xsl:value-of select="normalize-space($map)"/>
</xsl:template>

<xsl:template match="je:Pressure">
  <xsl:choose>
  <xsl:when test="@unit = 'hPa'">
  <xsl:value-of select="concat(text(), ' ', @unit)"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('Unsupported unit=[', @unit, ']')"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="je:Direction">
  <xsl:param name="undef"/>
  <xsl:choose>
  <xsl:when test="@condition"><xsl:value-of select="$undef"/></xsl:when>
  <xsl:otherwise>
    <xsl:value-of select="translate(text(), '東西南北', 'EWSN')"/>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="je:Speed | je:WindSpeed">
  <xsl:param name="use-condition" select="false()"/>
  <xsl:choose>
  <xsl:when test="$use-condition and (@condition = 'ゆっくり')"
  >SLOWLY</xsl:when>
  <xsl:when test="$use-condition and (@condition = 'ほとんど停滞')"
  >ALMOST STATIONARY</xsl:when>
  <xsl:when test="$use-condition and @condition">
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('Unsupported condition=[', @condition, ']')"/>
    </xsl:message>
  </xsl:when>
  <xsl:when test="@unit = 'ノット'">
    <xsl:value-of select="concat(text(), ' kt')"/>
  </xsl:when>
  <xsl:when test="@unit = 'm/s'">
    <xsl:value-of select="concat(text(), ' m/s')"/>
  </xsl:when>
  <xsl:when test="@unit = 'km/h'">
    <xsl:value-of select="concat(text(), ' km/h')"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('Unsupported unit=[', @unit, ']')"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="je:Coordinate" mode="confidence">
  <xsl:variable name="xlat"
    select="'|正確=GOOD|ほぼ正確=FAIR|不確実=POOR|'"/>
  <xsl:value-of select="fn:extract($xlat, @condition)"/>
</xsl:template>

<xsl:template match="je:Coordinate | je:BasePoint">
  <xsl:variable name="abslat" select="substring-before(normalize-space(
    translate(text(), '+-/', '   ')), ' ')"/>
  <xsl:variable name="abslon" select="substring-after(normalize-space(
    translate(text(), '+-/', '   ')), ' ')"/>
  <xsl:variable name="sgnlat" select="substring-before(normalize-space(
    translate(text(),
    '+-0123456789./',
    ' -             ')), ' ')"/>
  <xsl:variable name="sgnlon" select="substring-after(normalize-space(
    translate(text(),
    '+-0123456789./',
    ' -             ')), ' ')"/>
  <xsl:value-of select="normalize-space(
    concat($sgnlat, $abslat, ' ', $sgnlon, $abslon)
    )"/>
</xsl:template>

<xsl:template match="jm:ClassPart">
  <xsl:variable name="kaikyuu">
    <xsl:if test="je:TyphoonClass[@type='熱帯擾乱種類']/text()">
      <xsl:value-of select="concat('kaikyuu=',
      substring-before(substring-after(
      je:TyphoonClass[@type='熱帯擾乱種類']/text(), '('), ')'),
      '|')"/>
    </xsl:if>
  </xsl:variable>
  <!-- 大きさ階級または強さ階級が必要ならばここで追加 -->
  <xsl:value-of select="concat('|', $kaikyuu)"/>
</xsl:template>

<xsl:template match="jm:WindPart">
  <xsl:variable name="MXWD">
    <xsl:if test="je:WindSpeed[@type='最大風速'][@unit='ノット'] != '0'">
    <xsl:apply-templates
      select="je:WindSpeed[@type='最大風速'][@unit='ノット']"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="GUST">
    <xsl:if test="je:WindSpeed[@type='最大瞬間風速'][@unit='ノット'] != '0'">
    <xsl:apply-templates
      select="je:WindSpeed[@type='最大瞬間風速'][@unit='ノット']"/>
    </xsl:if>
  </xsl:variable>
  <xsl:value-of select="concat('|MXWD=', $MXWD, '|GUST=', $GUST, '|')"/>
</xsl:template>

<xsl:template match="jm:WarningAreaPart">
  <xsl:param name="LALO"/>
  <xsl:variable name="xrad"
    select="string(je:Circle/je:Axes/je:Axis[1]/je:Radius[@unit='km']/text())"/>
  <xsl:variable name="XRAD">
    <xsl:if test="$xrad != ''">
      <xsl:value-of select="concat('|XRAD=', $xrad, ' km')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="nrad"
    select="string(je:Circle/je:Axes/je:Axis[last()]/je:Radius[@unit='km']/text())"/>
  <xsl:variable name="NRAD">
    <xsl:if test="$nrad != ''">
      <xsl:value-of select="concat('|NRAD=', $nrad, ' km')"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="XDIR">
    <xsl:if test="je:Circle/je:Axes/je:Axis[1]/je:Direction != ''">
    <xsl:apply-templates select="je:Circle/je:Axes/je:Axis[1]/je:Direction"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="NDIR">
    <xsl:if test="je:Circle/je:Axes/je:Axis[last()]/je:Direction != ''">
    <xsl:apply-templates
    select="je:Circle/je:Axes/je:Axis[last()]/je:Direction"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="circle">
    <xsl:choose>
    <xsl:when test="$xrad = ''">
      <!-- no radius means no circle -->
    </xsl:when>
    <xsl:when test="$nrad = ''">
      <xsl:value-of select="concat('|circle=', $LALO, ' ', $xrad)"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:variable name="center">
	<xsl:call-template name="shift_latlon">
	  <xsl:with-param name="lalo" select="$LALO"/>
	  <xsl:with-param name="dirs" select="concat($XDIR,' ',$NDIR)"/>
	  <xsl:with-param name="shift"
	  select="(number($xrad) - number($nrad)) div 2.0"/>
	</xsl:call-template>
      </xsl:variable>
      <xsl:if test="$center != ''">
	<xsl:value-of select="concat('|circle=', $center, ' ',
	  ((number($xrad) + number($nrad)) div 2.0))"/>
      </xsl:if>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="headline">
    <xsl:choose>
    <xsl:when test="$xrad = ''"/>
    <xsl:when test="$xrad = $nrad">
      <xsl:value-of select="concat($xrad, ' km')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of
      select="concat($xrad, ' km ', $XDIR, ' ', $nrad, ' km ', $NDIR)"/>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="description">
    <xsl:choose>
    <xsl:when test="$xrad = ''"/>
    <xsl:when test="$xrad = $nrad">
      <xsl:value-of select="concat($xrad, ' km')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of
      select="concat(
      $xrad, ' km ', jm:SpellDirection($XDIR), ' ',
      $nrad, ' km ', jm:SpellDirection($NDIR))"/>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:value-of select="concat($circle, $XRAD, $NRAD,
  '|XDIR=', $XDIR, '|NDIR=', $NDIR, '|headline=', $headline,
  '|description=', $description, '|')"/>
</xsl:template>

<fn:function name="jm:SpellDirection">
  <xsl:param name="dir" />
  <xsl:variable name="DIRNAMES">
  |N=north|NNE=north-north-east|NE=north-east|ENE=east-north-east|
  |E=east|ESE=east-south-east|SE=south-east|SSE=south-south-east|
  |S=south|SSW=south-south-west|SW=south-west|WSW=west-south-west|
  |W=west|WNW=west-north-west|NW=north-west|NNW=north-north-west|
  </xsl:variable>
  <fn:result>
    <xsl:value-of select="fn:extract($DIRNAMES, $dir)"/>
  </fn:result>
</fn:function>

<fn:function name="jm:SpellKnot">
  <xsl:param name="sp" />
  <fn:result>
    <xsl:choose>
    <xsl:when test="contains($sp, ' kt')">
      <xsl:value-of select="concat(substring-before($sp, ' kt'),
      ' knots', substring-after($sp, ' kt'))"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$sp"/>
    </xsl:otherwise>
    </xsl:choose>
  </fn:result>
</fn:function>

<!-- shifts position by $shift kilometers on the Mercator-projected plane -->
<xsl:template name="shift_latlon">
  <xsl:param name="lalo"/>
  <xsl:param name="dirs"/>
  <xsl:param name="shift"/>
  <xsl:variable name="lat" select="number(substring-before($lalo, ' '))"/>
  <xsl:variable name="lon" select="number(substring-after($lalo, ' '))"/>
  <!-- cos(22.5 deg) * 6371.229 km * pi / 180 -->
  <xsl:variable name="deg" select="102.734"/>
  <xsl:variable name="sqrthalf" select="0.707107"/>
  <xsl:choose>
  <xsl:when test="$shift = 0">
    <xsl:value-of select="concat(
      format-number($lat, '00.0;-00.0'), ',',
      format-number($lon, '000.0;-000.0')
      )"/>
  </xsl:when>
  <xsl:when test="$dirs = 'N S'">
    <xsl:value-of select="concat(
      format-number(
	fn:reverse-mercator(fn:mercator($lat) + $shift div $deg),
	'00.0;-00.0'), ',',
      format-number($lon, '000.0;-000.0')
      )"/>
  </xsl:when>
  <xsl:when test="$dirs = 'S N'">
    <xsl:value-of select="concat(
      format-number(
        fn:reverse-mercator(fn:mercator($lat) - $shift div $deg),
	'00.0;-00.0'), ',',
      format-number($lon, '000.0;-000.0')
      )"/>
  </xsl:when>
  <xsl:when test="$dirs = 'E W'">
    <xsl:value-of select="concat(
      format-number($lat, '00.0;-00.0'), ',',
      format-number($lon + $shift div $deg, '000.0;-000.0')
      )"/>
  </xsl:when>
  <xsl:when test="$dirs = 'W E'">
    <xsl:value-of select="concat(
      format-number($lat, '00.0;-00.0'), ',',
      format-number($lon - $shift div $deg, '000.0;-000.0')
      )"/>
  </xsl:when>
  <xsl:when test="$dirs = 'NE SW'">
    <xsl:value-of select="concat(
      format-number(
        fn:reverse-mercator(fn:mercator($lat) + $shift div $deg * $sqrthalf),
	'00.0;-00.0'), ',',
      format-number($lon + $shift div $deg * $sqrthalf, '000.0;-000.0')
      )"/>
  </xsl:when>
  <xsl:when test="$dirs = 'NW SE'">
    <xsl:value-of select="concat(
      format-number(
        fn:reverse-mercator(fn:mercator($lat) + $shift div $deg * $sqrthalf),
	'00.0;-00.0'), ',',
      format-number($lon - $shift div $deg * $sqrthalf, '000.0;-000.0')
      )"/>
  </xsl:when>
  <xsl:when test="$dirs = 'SE NW'">
    <xsl:value-of select="concat(
      format-number(
        fn:reverse-mercator(fn:mercator($lat) - $shift div $deg * $sqrthalf),
	'00.0;-00.0'), ',',
      format-number($lon + $shift div $deg * $sqrthalf, '000.0;-000.0')
      )"/>
  </xsl:when>
  <xsl:when test="$dirs = 'SW NE'">
    <xsl:value-of select="concat(
      format-number(
        fn:reverse-mercator(fn:mercator($lat) - $shift div $deg * $sqrthalf),
	'00.0;-00.0'), ',',
      format-number($lon - $shift div $deg * $sqrthalf, '000.0;-000.0')
      )"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:message terminate="yes">
      <xsl:value-of select="concat('Unexpected dirs=[', $dirs, ']')"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- takes latitude in degree;
  returns projected latitude in equivalent degree.
  standard latitude = 22.5 degree (as defined in WMO GDPFS Manual) -->
<xsl:template name="fn:mercator">
  <xsl:param name="lat"/>
  <xsl:variable name="b" select="number($lat)"/>
  <xsl:copy-of select="
    $b * (0.972945 + $b * $b * (5.2293e-5
    + $b * $b * (1.5216e-9 + $b * $b * 9.417e-13))) "/>
</xsl:template>

<fn:function name="fn:mercator">
  <xsl:param name="lat"/>
  <fn:result>
  <xsl:call-template name="fn:mercator">
  <xsl:with-param name="lat" select="$lat"/>
  </xsl:call-template>
  </fn:result>
</fn:function>

<xsl:template name="fn:reverse-mercator">
  <xsl:param name="lateq"/>
  <xsl:variable name="b" select="number($lateq)"/>
  <xsl:copy-of select="
    $b * (1.026088353 + $b * $b * (-5.3e-5 
    + $b * $b * (2.89271811332772e-9 - $b * $b * 2.88553662178e-15))) "/>
</xsl:template>

<fn:function name="fn:reverse-mercator">
  <xsl:param name="lateq"/>
  <fn:result>
  <xsl:call-template name="fn:reverse-mercator">
  <xsl:with-param name="lateq" select="$lateq"/>
  </xsl:call-template>
  </fn:result>
</fn:function>

<xsl:template name="datetime_add">
  <xsl:param name="t" select="'2012-12-31T23:59:59+09:00'"/>
  <xsl:param name="dt" select="''"/>
  <!-- break down $t -->
  <xsl:variable name="y1" select="number(substring-before($t,'-'))"/>
  <xsl:variable name="m1" select="number(
    substring-before(substring-after($t,'-'),'-'))"/>
  <xsl:variable name="d1" select="number(substring-after(
    substring-after(substring-before($t,'T'),'-'),'-'))"/>
  <xsl:variable name="h1" select="number(
    substring-before(substring-after($t,'T'),':'))"/>
  <xsl:variable name="n1" select="number(
    substring-before(substring-after(substring-after($t,'T'),':'),':'))"/>
  <xsl:variable name="s1" select="substring-before(
    substring-after(substring-after(substring-after($t,'T'),':'),':'),'+')"/>
  <!-- break down timzone -->
  <xsl:variable name="hz" select="number(
    substring-before(substring-after($t, '+'), ':'))"/>
  <xsl:variable name="nz" select="number(
    substring-after(substring-after($t, '+'), ':'))"/>
  <!-- break down $dt -->
  <xsl:variable name="dtx" select="concat($dt,
    substring('00:00', 1 + string-length($dt), 5 - string-length($dt)))"/>
  <xsl:variable name="hd" select="number(substring-before($dtx, ':'))"/>
  <xsl:variable name="nd" select="number(substring-after($dtx, ':'))"/>
  <!-- compute added time -->
  <xsl:variable name="ns" select="$n1 - $nz + $nd"/>
  <xsl:variable name="hc" select="floor($ns div 60)"/>
  <xsl:variable name="n2" select="$ns - 60 * $hc"/>
  <xsl:variable name="hs" select="$h1 - $hz + $hd + $hc"/>
  <xsl:variable name="dc" select="floor($hs div 24)"/>
  <xsl:variable name="h2" select="$hs - 24 * $dc"/>
  <!-- now $dc is carry of date which can be positive or negative -->
  <xsl:variable name="m0" select="$m1 + number($m1 &lt;= 2) * 12"/>
  <xsl:variable name="y0" select="$y1 - number($m1 &lt;= 2) - 1600"/>
  <xsl:variable name="OLYMPIAD" select="365 * 4 + 1"/>
  <xsl:variable name="CENTURY" select="$OLYMPIAD * 25 - 1"/>
  <xsl:variable name="CENTURY4" select="$CENTURY * 4 + 1"/>
  <xsl:variable name="seq1" select="
    $d1 + $dc + floor((306 * ($m0 + 1)) div 10) - 123
    + ($y0 mod 4) * 365
    + floor(($y0 mod 100) div 4) * $OLYMPIAD
    + floor(($y0 mod 400) div 100) * $CENTURY
    + floor($y0 div 400) * $CENTURY4
  "/>
  <xsl:variable name="q" select="floor($seq1 div $CENTURY4)"/>
  <xsl:variable name="seq2" select="floor($seq1 mod $CENTURY4)"/>
  <xsl:variable name="c0" select="floor($seq2 div $CENTURY)"/>
  <xsl:variable name="c" select="$c0 - number($c0 = 4)"/>
  <xsl:variable name="seq3"
    select="floor($seq2 mod $CENTURY) + number($c0 = 4) * $CENTURY"/>
  <xsl:variable name="o" select="floor($seq3 div $OLYMPIAD)"/>
  <xsl:variable name="seq4" select="floor($seq3 mod $OLYMPIAD)"/>
  <xsl:variable name="a0" select="floor($seq4 div 365)"/>
  <xsl:variable name="a" select="$a0 - number($a0 = 4)"/>
  <xsl:variable name="seq5"
    select="floor($seq4 mod 365) + number($a0 = 4) * 365"/>
  <xsl:variable name="m2" select="floor(($seq5 * 10 + 4) div 306) + 3"/>
  <xsl:variable name="d2" select="$seq5 - floor((306 * $m2 + 6) div 10) + 93"/>
  <xsl:variable name="y2" select="1600 + $q * 400 + $c * 100 + $o * 4 + $a
  + number($m2 &gt; 12)"/>
  <xsl:variable name="m3" select="$m2 - 12 * number($m2 &gt; 12)"/>
  <xsl:value-of select="concat(
    format-number($y2, '0000'),'-',
    format-number($m3, '00'),'-',
    format-number($d2, '00'),'T',
    format-number($h2, '00'),':',
    format-number($n2, '00'),':',
    $s1,'+00:00'
  )"/>
</xsl:template>

<fn:function name="fn:extract">
  <xsl:param name="hash"/>
  <xsl:param name="key"/>
  <xsl:param name="delim" select="'|'"/>
  <xsl:param name="sep" select="'='"/>
  <fn:result>
  <xsl:value-of select="substring-before(
    substring-after($hash,
      concat($delim, $key, $sep)
    ), $delim
  )"/>
  </fn:result>
</fn:function>

<xsl:template name="flatten_digits">
  <xsl:param name="string"/>
  <xsl:value-of select="translate($string, '0123456789', '9999999999')"/>
</xsl:template>

</xsl:stylesheet>
