<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

<xsl:key name="kvpick" match="p" use="@k"/>

<xsl:template match="/">
  <xsl:for-each select="kv/p">
    <xsl:variable name="v" select="@v"/>
    <xsl:variable name="k" select="@k"/>
    <xsl:if test="string(@v) = ''">
      <xsl:message terminate="yes">
      <xsl:value-of select="concat(
      'Missing area code for lat/lon=[', $k, ']')"/>
      </xsl:message>
    </xsl:if>
    <xsl:for-each select="document('vloc2.xml')/hash">
      <xsl:if test="count(key('kvpick', $v)/@en) = 0">
	<xsl:message terminate="yes">
	<xsl:value-of select="concat('Undefined area code ', $v, ' at ', $k)"/>
	</xsl:message>
      </xsl:if>
    </xsl:for-each>
  </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
