<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fn="http://exslt.org/functions"
>

<xsl:import href="vptw2cap.xsl"/>

<xsl:output method="text"/>

<xsl:param name="fn" select="'test-mercator.xml'"/>

<xsl:template match="/">
  <xsl:apply-templates name="*/test"/>
</xsl:template>

<xsl:template match="test">
  <xsl:variable name="beq">
    <xsl:call-template name="fn:mercator">
    <xsl:with-param name="lat" select="lat/text()"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="lat2">
    <xsl:call-template name="fn:reverse-mercator">
    <xsl:with-param name="lateq" select="$beq"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:if test="($beq - beq) * ($beq - beq) &gt; 0.0001">
    <xsl:message terminate="yes">
      <xsl:value-of
      select="concat($fn,':', position() div 2 + 1,': mer[',lat,'] = [',$beq,'], |',($beq - beq) * ($beq - beq),'| &gt; 0.01')"/>
    </xsl:message>
  </xsl:if>
  <xsl:if test="($lat2 - lat/text()) * ($lat2 - lat/text()) &gt; 0.0004">
    <xsl:message terminate="yes">
      <xsl:value-of
      select="concat($fn,':', position() div 2 + 1,
      ': rev[mer[',lat,']] = [',$lat2,'] != [', lat, ']')"/>
    </xsl:message>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
