<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cap="urn:oasis:names:tc:emergency:cap:1.2"
>

<xsl:output method="text"/>

<xsl:template match="/">
  <xsl:apply-templates select=".//cap:parameter"/>
</xsl:template>

<xsl:template match="cap:parameter[cap:valueName='TC_Classification']">
  <xsl:choose>
  <xsl:when test="cap:value='TY'"/>
  <xsl:when test="cap:value='STS'"/>
  <xsl:when test="cap:value='TS'"/>
  <xsl:when test="cap:value='TD'"/>
  <xsl:when test="cap:value='Hurricane'"/>
  <xsl:when test="cap:value='Tropical Storm'"/>
  <xsl:when test="cap:value='LOW'"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter[cap:valueName='TC_CycloneName']">
  <xsl:choose>
  <xsl:when test="translate(cap:value, ' -ABCDEFGHIJKLMNOPQRSTUVWXYZ', '')=''"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter[cap:valueName='TC_Location']">
  <!--  there will be this check
  <xsl:choose>
  <xsl:when test="translate(cap:value,
  ' .-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz', '')=''"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
  -->
</xsl:template>

<xsl:template match="cap:parameter[cap:valueName='TC_CycloneID']">
  <xsl:choose>
  <xsl:when test="translate(cap:value, '0123456789', '##########')='####'"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter[cap:valueName='TC_MovingDirection']">
  <xsl:choose>
  <xsl:when test="cap:value='N'"/>
  <xsl:when test="cap:value='NNE'"/>
  <xsl:when test="cap:value='NE'"/>
  <xsl:when test="cap:value='ENE'"/>
  <xsl:when test="cap:value='E'"/>
  <xsl:when test="cap:value='ESE'"/>
  <xsl:when test="cap:value='SE'"/>
  <xsl:when test="cap:value='SSE'"/>
  <xsl:when test="cap:value='S'"/>
  <xsl:when test="cap:value='SSW'"/>
  <xsl:when test="cap:value='SW'"/>
  <xsl:when test="cap:value='WSW'"/>
  <xsl:when test="cap:value='W'"/>
  <xsl:when test="cap:value='WNW'"/>
  <xsl:when test="cap:value='NW'"/>
  <xsl:when test="cap:value='NNW'"/>
  <xsl:when test="cap:value=''"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter[cap:valueName='TC_MovingSpeed']">
  <xsl:choose>
  <xsl:when test="translate(cap:value, '6789', '##########')='# kt'"/>
  <xsl:when test="translate(cap:value, '0123456789', '##########')='## kt'"/>
  <xsl:when test="cap:value='100 kt'"/>
  <xsl:when test="cap:value='SLOWLY'"/>
  <xsl:when test="cap:value='ALMOST STATIONARY'"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter[cap:valueName='TC_PositionConfidence']">
  <xsl:choose>
  <xsl:when test="cap:value='GOOD'"/>
  <xsl:when test="cap:value='FAIR'"/>
  <xsl:when test="cap:value='POOR'"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter[cap:valueName='TC_CenterPressure']">
  <xsl:choose>
  <xsl:when test="translate(cap:value, '0123456789', '##########')='### hPa'"/>
  <xsl:when test="translate(cap:value, '0123456789', '##########')='#### hPa'"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter[cap:valueName='TC_MaxSustainedWind'
or cap:valueName='TC_PeakGust']">
  <xsl:choose>
  <xsl:when test="translate(cap:value, '0123456789', '##########')='## kt'"/>
  <xsl:when test="translate(cap:value, '0123456789', '##########')='### kt'"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter[
  cap:valueName='TC_MaxGaleRadius' or
  cap:valueName='TC_MinGaleRadius' or
  cap:valueName='TC_MaxStormRadius' or
  cap:valueName='TC_MinStormRadius'
  ]">
  <xsl:choose>
  <xsl:when test="translate(cap:value, '0123456789', '##########')='## km'"/>
  <xsl:when test="translate(cap:value, '0123456789', '##########')='### km'"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter[
  cap:valueName='TC_MaxGaleRadiusDirection' or
  cap:valueName='TC_MinGaleRadiusDirection' or
  cap:valueName='TC_MaxStormRadiusDirection' or
  cap:valueName='TC_MinStormRadiusDirection'
  ]">
  <xsl:choose>
  <xsl:when test="cap:value='N'"/>
  <xsl:when test="cap:value='NE'"/>
  <xsl:when test="cap:value='E'"/>
  <xsl:when test="cap:value='SE'"/>
  <xsl:when test="cap:value='S'"/>
  <xsl:when test="cap:value='SW'"/>
  <xsl:when test="cap:value='W'"/>
  <xsl:when test="cap:value='NW'"/>
  <xsl:when test="cap:value=''"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter[cap:valueName='UUID']">
  <xsl:choose>
  <xsl:when test="translate(cap:value, '0123456789abcdef',
  '################')='########-####-####-####-############'"/>
  <xsl:otherwise>
    <xsl:message terminate="yes">
    <xsl:value-of select="concat('bad ', cap:valueName, ' = ', cap:value)"/>
    </xsl:message>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="cap:parameter">
  <xsl:message terminate="yes">
  <xsl:value-of select="concat('parameter ', cap:valueName, ' undefined')"/>
  </xsl:message>
</xsl:template>

</xsl:stylesheet>
